/* echoes.c -- a moxc example */

#include "musiprog.h"

#define delay 15

char *app_syntax = "";

void echo(chan, pitch, vel)
{
    vel = vel - 5;
    if (vel > 0) {
	/* for some synthesizers, this line isn't necessary: */
	    midi_note(chan, pitch, 0);
	midi_note(chan, pitch, vel);
	cause(delay, echo, chan, pitch, vel);
    } else {
	midi_note(chan, pitch, 0);
    }
}


void keydown(int chan, int pitch, int vel)
{
    cause(delay, echo, chan, pitch, vel);
}


void mainscore()
{
    cause(1000, mainscore);
}


/* asciievent -- ascii event handler */
/**/
void asciievent(char c)
{
    if (c == 'q') quit();
    else gprintf(TRANS, "Type q to quit.\n");
}


/* keyup -- key up handler */
/**/
void keyup(int c, int k)
{
    /* insert key up actions here */
}


/* prgmchange -- program change handler */
/**/
void prgmchange(int chan, int value)
{
	/* insert program change actions here */
}


/* bendchange -- pitch bend handler */
/**/
void bendchange(int chan, int value)
{
	/* insert pitchbend actions here */
}


/* ctrlchange -- control change handler */
/**/
void ctrlchange(int chan, int ctrl, int value)
{
	/* insert control change actions here */
}


/* peddown -- pedal down handler */
/**/
void peddown(int c)
{
	/* insert pedal down actions here */
}


/* pedup -- pedal up handler */
/**/
void pedup(int c)
{
	/* insert pedal up actions here */
}


/* touchchange -- after touch handler */
/**/
void touchchange(int chan, int value)
{
	/* insert after touch actions here */
}


/* coda -- what to do at end of performance */
/*
 * NOTE: this is called just before closing down the midi interface.
 */
void coda(void)
{
}


/* midievent -- called when mididecode == false */
/**/
void midievent(data)
  unsigned char data[4];
{
}


/* sysex -- sysex message handler */
/**/
void sysex()
{
	/* Insert sysex actions here.
	   Hint: get the sysex message by calling getxbuf
	 */
}


#ifdef AMIGA
void buttonchange(number, value)
{
}

void propchange(number, value)
{
	/* insert propchange actions here */
}
#endif
