/* exput.c -- program to send Yamaha exclusive messages from file */
/* Copyright 1989 Carnegie Mellon University */

/*****************************************************************************
*       Change Log
*  Date | Change
*-----------+-----------------------------------------------------------------
* 13-Jun-86 | Created Change Log
*  6-Aug-86 | Adapted to Lattice C V3.00
* 24-Oct-88 | JCD : Portable version.
* 31-Oct-89 | Fixed up command line interface for cmt89 (RBD)
* 5 -Apr-91 |Further changes
*  6-Mar-92 | GWL : ok for DOS
*****************************************************************************/
#include "ctype.h"
#include "cext.h"
#include "stdio.h"
#include "midifns.h"
#include "userio.h"
#include "midicode.h"
#include "cmdline.h"
#include "excldesc.h"

#ifdef THINK
#include "console.h"
#endif

int debug = false; /* used in userio.c, declared in moxc.c, but we're not using moxc.c */

extern int abort_flag;

/* #define buffsize 16*1024L */
long buffsize = 16*1024L;
byte *midibuff;

/*****************************************************************************
*    Routines local to this module
*****************************************************************************/

private void    instruct();
private boolean output();
private boolean readbuff();
private void report_overflow();

private void error_exit()
{
#ifndef MACINTOSH /* Mac will prompt for return anyway */
    gprintf(TRANS, "Type anything to exit...");
    ggetchar();
#endif
}


/****************************************************************************
*               instruct
* Effect: prints instructions for this routine
****************************************************************************/

private void instruct()
{
    gprintf(TRANS,"This program sends system exclusive messages previously\n");
    gprintf(TRANS,"saved by the exget program.  You must set up your\n");
    gprintf(TRANS,"synthesizer to receive the system exclusive messages\n");
    gprintf(TRANS,"See the CMU Midi Toolkit Manual for more details\n");
}



/****************************************************************************
*               main
* Effect: main program -- prompt user for information and put data
****************************************************************************/

void main(argc, argv)
  int argc;
  char *argv[];
{

    FILE *fp;           /* the input file */
    int count;          /* length of data in file */
    byte *msg;          /* message pointer */
    boolean done = false;       /* flag is true when user is done */
    boolean data_ready; /* file read was successful */
    char filename[100]; /* the output file name */
    char *s;            /* the file name in the command line */
    char *size;         /* buffer size option from command line */

#ifdef THINK
    /* Macintosh needs help to provide Unix-style command line */
    argc = ccommand(&argv);
#endif	
    io_init();
    cl_syntax(midifns_syntax);
    cl_syntax("help<s>Print help info;\
	size<o>Specifies minimum buffer size in bytes;\
	script<s>Do not run interactively");
    if (!cl_init(argv, argc)) {
	error_exit();
	goto finish;
    }
    if (cl_switch("-help")) instruct();
    size = cl_option("size");
    if (size != NULL) {
	int newsize = atoi(size);
	if (newsize > buffsize) buffsize = newsize;
    }
    if (size != NULL) {
	int newsize = atoi(size);
	/* go up by powers of two until you exceed requested size */
	while (newsize > buffsize) buffsize += buffsize;
    }

    midibuff = (byte *) MALLOC((size_t) buffsize);
    if (!midibuff) {
	gprintf(TRANS, "buffer allocation failed\n");
	error_exit();
	goto finish;
    }   

    filename[0] = EOS;    /* empty string */
    if (s = cl_arg(1)) {
	strcpy(filename, s); /* get input file name */
	if (s = cl_arg(2))
	    gprintf(ERROR, "Extra (filename?) argument ignored: %s\n", s);
    }
    musicinit();

    while (!done) {
	data_ready = false;
	while (!data_ready) {
	    if (!cl_switch("script") &&
		askbool("Do you want instructions", false)) instruct();
	    fp = fileopen(filename, "syx", "r", "file name (^G to exit)");
	    if (!fp) goto finish;
	    data_ready = readbuff(fp, midibuff, &count, fileopen_name);
	    /* note that readbuff closes the file */
	    filename[0] = EOS;	/* make sure next fileopen prompts user */
	    if (!data_ready) {
		gprintf(TRANS,"Something is wrong with your data or you typed the\n");
		gprintf(TRANS,"wrong file name.  Please try again.\n");
	    }
	}

	gprintf(TRANS,"%d bytes read.\n", count);

	if (!cl_switch("script")) {
	    gprintf(TRANS,"Ready with your data. Type space when you are ready...\n");
	    while ((char)wait_ascii() != ' ' && !abort_flag) /**/ ;
	}
#ifdef DOS
	exclusive(true);
#endif
	msg = midibuff;
	while (!abort_flag && output(&msg, midibuff + count))
	    /* write messages */ ;
	gprintf(TRANS,"DONE!\n");
	done = abort_flag || cl_switch("script") ||
	       !askbool("Do you want to send another file", true);
	filename[0] = EOS;    /* force prompt for new file name */
    }    
  finish:
    EXIT(0);
}


/****************************************************************************
*               output
* Inputs:
*    byte **msg: pointer to message to send
*    byte *msg_tail: pointer to byte after last message byte
* Outputs:
*    *msg is set to byte after last byte of the message sent
*    returns true if there is more data to send
* Effect: sends exclusive messages using recorded data
* Assumes: msg_tail > *msg
* Implementation:
****************************************************************************/

private boolean output(msg, msg_tail)
byte **msg;
byte *msg_tail;
{
  byte *this_msg = *msg;
  int OK;       /* OK to send message */
/*
    gprintf(GDEBUG,"*msg %x, this_msg %x, msg_tail %x\n",
	    *msg, this_msg, msg_tail);
    gprintf(GDEBUG,"%d bytes to go.\n", msg_tail - this_msg);
*/
    excldesc(this_msg);
    this_msg = *msg;
	
    if (isdangerous(this_msg)) {
	OK = askbool("Are you sure", false);
    } else {
	OK = true;
    }
    if (OK) {
	midi_exclusive(this_msg);
    }
    do {                        /* always skip first byte, */
	this_msg++;             /* then terminate after finding MIDI_EOX */
    } while ((this_msg < msg_tail) && (*(this_msg-1) != MIDI_EOX));

    *msg = this_msg;
    return (boolean)(this_msg < msg_tail);
}


/****************************************************************************
*               readbuff
* Inputs:
*    FILE *fp: file from which to read
* Outputs:
*    byte *buff: where to put the data
*    int *count: count is set to the number of of bytes read
* Effect: 
*    read midi exclusive data from a file into buff, print error if buffer
*    is too small
* Assumes:
*    fp is open for reading
****************************************************************************/

private boolean readbuff(fp, buff, count, filename)
  FILE *fp;
  byte *buff;
  int *count; /* result */
  char *filename;
{
    int i;
    int c;
    boolean binary_mode;

    /* first find out if this is a binary or ascii file */
    /* if it's binary, the first byte should be a midi status byte, so
     * it will have its high order bit set
     */
    *count = 0;
    c = getc(fp);
    if (c == EOF) {
	gprintf(TRANS, "Empty file!\n");
	return false;
    }
    binary_mode = (c & 0x80) != 0;
    ungetc(c, fp);

    if (binary_mode) {
#ifndef UNIX
	/* if it's not UNIX, we need to reopen the file in binary mode */
	fclose(fp);
	fp = fopen(filename, "rb");
#endif
	while ((c = getc(fp)) != EOF) {
	    (*count)++;
	    if (*count <= buffsize) *buff++ = c;
	}
    } else { /* ascii (hex) file format */
	while (fscanf(fp, "%x", &i) > 0) {
	    (*count)++;
	    if (*count <= buffsize) *buff++ = i;
	}
    }
    if (*count > buffsize) {
	report_overflow(*count);
	return false;
    } else return (boolean) (*count != 0);
    fclose(fp);
}


/* report_overflow -- print explanation to user */
/**/
private void report_overflow(count)
  int count;
{
    gprintf(TRANS, "Buffer too small for system exclusive data.  Run\n");
    gprintf(TRANS, "program again with this option: -size %d\n\n", count);
}
