/* template.c -- a template for CMU Midi Toolkit programmers */

#include "musiprog.h"
#include "seq.h"
#include "mapper.h"
#include "ctype.h"

extern char lastfile_name[100];

/* asciievent -- ascii event handler */
/**/
void asciievent(char c)
{
    if (c == 'Q') quit();
    else if (c == '?') mapper_show_active();
    else if (c == '#') {
	mapper_flush_scores();
	gprintf(TRANS, "Scores will be reloaded with next map load\n");
    } else if (c == '!' || c == '@') {
	FILE *f;
	char first;
	char *deflt;
	if (c == '!') {
	    gprintf(TRANS, "Reloading %s ...\n ", lastfile_name);
	    deflt = lastfile_name;
	} else deflt = "";
	f = fileopen(deflt, "crn", "r", "Map file");
	if (f) {
	    strcpy(lastfile_name, fileopen_name);
	    first = map_read(f);
	    fclose(f);
	    if (first) {
		map_install(first);
		gprintf(TRANS, "Map %c installed\n", first);
	    }
	} else gprintf(TRANS, "no file found!\n");
    } else if (isalpha(c)) {
	map_install(c);
    } else gprintf(TRANS, "Type Q to quit.\n");
}


/* keyup -- key up handler */
/**/
void keyup(int c, int k)
{
	map_noteoff(c, k);
}


/* keydown -- key down handler */
/**/
void keydown(int c, int k, int v)
{
	map_event(c, k, v, 0, NULL);
}


/* midievent -- handle a midi message */
/**/
void midievent(midi_data)
  byte midi_data[4];
{
	/* this is only called if mididecode is false so */
	/* you can assume this function is never called  */
}


/* prgmchange -- program change handler */
/**/
void prgmchange(int chan, int value)
{
	/* insert program change actions here */
}


/* bendchange -- pitch bend handler */
/**/
void bendchange(int chan, int value)
{
	/* insert pitchbend actions here */
}


/* peddown -- pedal down handler */
/**/
void peddown(int c)
{
	/* insert pedal down actions here */
}


/* pedup -- pedal up handler */
/**/
void pedup(int c)
{
	/* insert pedal up actions here */
}


/* sysex -- message handler */
/**/
void sysex()
{
}


/* touchchange -- after touch handler */
/**/
void touchchange(int chan, int value)
{
	/* insert after touch actions here */
}


/* coda -- what to do at end of performance */
/*
 * NOTE: this is called just before closing down the midi interface.
 */
void coda(void)
{
}
