PROJ =	C201
OBJS =	C200.obj C200ASC.obj C200FIO.obj C200KEY.obj C200M000.obj C201M001.obj\
	C200M002.obj C200RAN.obj C200SCO.obj
DEBUG =	0

# M is the memory model
M	= L

# L is the log option
L	= >> xlog

# P is the extended map option
P	= /m

# select the compiler
CC  = qcl $L

# include library
H	= ..\..\..\..\LIB

# general compiler flags
CFLAGS_G  = /A$M /batch /c /nologo /I$H

# for debugging
CFLAGS_D  = /Zr /Od /W4

# for running
CFLAGS_R  = /Ox /W1

# for library
CFLAGS_L  = /Zl

# for application
CFLAGS_A  =

MAPFILE_R  = NUL
LFLAGS_G  = /NOI /BATCH /NOE /NOL
LFLAGS_R  = /E
LINKER	= qlink $L

LIBS_EXT  = ..\..\..\..\LIB\CMTLIB.LIB
LIBS  = $(LIBS_EXT)

all: $(PROJ).exe

.c.obj :
!IF $(DEBUG)
	$(CC) $(CFLAGS_G) $(CFLAGS_D) $(CFLAGS_A) $*.c
!ELSE
	$(CC) $(CFLAGS_G) $(CFLAGS_R) $(CFLAGS_A) $*.c
!ENDIF

$(PROJ).exe : $(OBJS) $(LIBS)
	@echo>NUL <<$(PROJ).lrf
$(OBJS: = +^
)
$@
$(MAPFILE_R)
$(LIBS: = +^
)
;
<<
	@echo>>xlog $@
	$(LINKER) $(LFLAGS_G) $(LFLAGS_R) @$(PROJ).lrf

run: $(PROJ).exe
	$(PROJ).exe $(RUNFLAGS)

