/* c200sco -- process score entries */

/*
    Copyright pending, Intelligistics, Inc.

    Please see the notice in the main module associated with 
    this submodule: c200.c

*/
/*
    Revisions:

    200 -- gwl I*I 21-Jun-90 -- created
*/

/* definitions */

#include 	"cmtprog.h"
#include	"cscdef.h"				/* definitions and externals */
#include	"keydef.h"
#include	"alloent.h"
#include	"stdio.h"
#include	"ascdef.h"				/* definitions for keys in */
#include	"ctype.h"				/* for text routines */
#include	"string.h"

/* useful macros */

#define		nextitem(fmt,addr) \
		if ((scancode=fscanf(sp,fmt,addr))!=1)goto donescore

#define		docitem(fmt,val) \
		if (showdata) gprintf(TRANS, fmt,val)

#define		docend \
		if (showdata) gprintf(TRANS, "\n")

#define		checkitem(cond,msg) \
		if (!(cond)) \
		{ \
		    gprintf(TRANS, msg); \
		    endline(sp); \
		}

#define		savem000(value) \
		checkitem((i<NECHOVALS)," too many algorithm 0 values") \
		mode[id].mp.m000p->val[i++] = value; 

#define		savem001(item,value) \
		mode[id].mp.m001p-> item = value;

#define		savem002(item,value) \
		mode[id].mp.m002p-> item = value;

/* external data */

	int		showdata=0;			/* 1=show details */
static	int		scanning=0;
static	int		scancode;			/* return code from fscanf */

/******************************************************************************
    scan to end of line
******************************************************************************/
void endline(sp)
FILE	*sp;	/* score file pointer */
{
    char	t[LTEXT];
    fgets(t,LTEXT,sp);
}


/******************************************************************************
    read data from score file
******************************************************************************/

score_data(sp)
FILE	*sp;	/* score file pointer */
{

    char	t[LTEXT];		/* temporary character string */
    int		id;				/* identification index */
    int		i,n,m;			/* indices */
    int		v;				/* temporary value */
    long	l;				/* temporary value */

    /* loop on first character of line */

    scanning=1;
    while(scanning)
    {
	nextitem("%s",t);

	switch (t[0])
	{

	case 'm':						/* define mode */

	    nextitem("%d",&id);
	    docitem("Define mode %d:",id);
	    checkitem((id<NMODES)," bad mode#");

	    if (mode[id].mp.m000p)		/* if already exists, free space */
		free(mode[id].mp.m000p);

	    nextitem("%d",&mode[id].algnum);
	    docitem(" alg %d",mode[id].algnum);
	    checkitem((mode[id].algnum<NALGS)," bad#\n");
	    switch (mode[id].algnum)
	    {

	    case 0:						/* algorithm 000 -- echo */

		alloent(mode[id].mp.m000p,m000data,"score_data",1,"m000data");

		i=0;					/* steps through values */
		nextitem("%d",&n);
		docitem(" %d chans",n);
		checkitem((n<NCHANS),"  -- bad#\n");
		savem000(n);

		while(n--)
		{
		    nextitem("%d",&v);
		    docitem(" ch %d:",v);
		    checkitem((v<NCHANS)," -- bad#\n");
		    savem000(v);

		    nextitem("%d",&m);
		    docitem(" %d ts:",m);
		    savem000(m);

		    while(m--)
		    {
			nextitem("%d",&v);
			docitem(" %d",v);
			savem000(v);
		    }
		}
		docend;
		m000init(mode[id].mp.m000p);
		break;

	    case 1:						/* algorithm 001 -- multiple keys */

		alloent(mode[id].mp.m001p,m001data,"score_data",1,"m001data");
		nextitem("%d",&v);
		docitem(" casc %d",v);
		checkitem((v<NCASCS)," -- bad#\n");
		savem001(cp,&casc[v]);

		nextitem("%d",&v);
		docitem(" #use %d",v);
		checkitem((v<=NUSEMAX)," -- bad#\n");
		savem001(nkeysuse,v);

		nextitem("%d",&v);
		docitem(" cont? %d",v);
		savem001(usemore,v);

		nextitem("%ld",&l);
		docitem(" delay %ld\n",l);
		savem001(resetdelay,l);

		m001init(mode[id].mp.m001p);
		break;

	    case 2:						/* algorithm 002 -- hot keys */

		alloent(mode[id].mp.m002p,m002data,"score_data",1,"m002data");
/*
gprintf(TRANS, "\nc200sco mp %u m %d\n",mode[id].mp.m002p,id);
*/
		nextitem("%d",&v);
		docitem(" casc %d",v);
		checkitem((v<NCASCS)," -- bad#\n");
		savem002(cp,&casc[v]);

		nextitem("%d",&n);
		docitem(" #keys %d:",n);
		checkitem((n<NHOTKEYS)," -- bad#\n");
		savem002(nhot,n);

		i=0;
		while(n--)
		{
		    nextitem("%d",&v);
		    docitem(" %d",v);
		    savem002(hotkey[i++],v);
		}
		docend;
		m002init(mode[id].mp.m002p);
		break;
	    }
	    break;

	case 'i':						/* instrument */

	    nextitem("%d",&id);
	    docitem("Define inst %d:",id);
	    checkitem((id<NINSTS)," -- bad#");

	    nextitem("%d",&inst[id].channel);
	    docitem(" chan %d",inst[id].channel);
	    checkitem((inst[id].channel<NCHANS)," -- bad#\n");

	    nextitem("%d",&n);
	    docitem(" #outs %d:",n);
	    checkitem((n<NOMODES)," -- bad#\n");
	    inst[id].nomodes=n;

	    i=0;
	    while(n--)
	    {
		nextitem("%d",&v);
		docitem(" %d",v);
		checkitem((v<NMODES)," -- bad#\n");
		inst[id].omode[i++]=v;
	    }
	    docend;
	    break;

	case 'c':						/* cascades paraeter file */

	    nextitem("%d",&id);
	    docitem("Parmset casc %d:",id);
	    checkitem((id<NCASCS)," -- bad#\n");

	    nextitem("%s",t);
	    docitem(" %s:",t);
	    curcp=&casc[id];
	    read_file(t);
	    docitem(" %s\n",curcp->title);

	    break;

	case 'p':						/* immediate program changes */

	    nextitem("%d",&n);
	    docitem("Send %d program changes:",n);
	    while(n--)
	    {
		nextitem("%d",&id);
		docitem(" chan %d",id);
		checkitem((id<NCHANS)," -- bad#\n");
		nextitem("%d",&v);
		docitem(" gets %d",v);
		midi_program(id,v);
		inst[id-1].currprog=v;	/* temporary -- links in and out */
	    }
	    docend;
	    break;

	case '?':						/* toggle showing data */

	    showdata=1-showdata;
	    break;

	case '=':						/* ready to play */

	    docitem("Ready\n",v);
	    scanning=0;
	    break;

	case '*':						/* comment */

	    fgets(t,LTEXT,sp);
	    docitem("*%s",t);
	    break;

	default:

	    docitem("Unrecognizable %s\n",t);
	    endline(sp);
	    break;

	}
    }
    return(0);							/* ok */

donescore:
    if (scancode!=EOF)
    {
	gprintf(TRANS, "score_data: end code %d\n",scancode);
    }
    return(scancode);
}

