/* c200m002 -- algorithm 002 -- hot key triggers */

/*
    Copyright pending, Intelligistics, Inc.

    Please see the notice in the main module associated with 
    this submodule: c200.c

*/
/*
    Revisions:

    200 -- gwl I*I 19-JUn-90 -- created
*/

/* definitions */

#include	"cscdef.h"				/* definitions and externals */
#include	"keydef.h"
#include	"stdio.h"
#include	"ascdef.h"				/* definitions for m002s in */
#include	"ctype.h"				/* for text routines */
#include	"string.h"


/******************************************************************************
    m002down -- check for trigger
******************************************************************************/

void m002down(mp,ch,p,v)
struct m002data	*mp;	/* data area */
int				ch;		/* channel */
int				p;		/* pitch */
int				v;		/* velocity */
{

    int		i;

/*
gprintf(TRANS, "m002down: ch %d, p %d, v %d\n",ch,p,v);
*/
    /* search for key among the hots */

    for (i=0; i<mp->nhot; i++)
    {
	if (p==mp->hotkey[i])			/* found it */
	{
	    mp->cp->pit.valmin=p;		/* use p */
	    mp->cp->pit.valmax=p;
	    mp->cp->lou.valmin=v;		/* and v */
	    mp->cp->lou.valmax=v;
	    cascinit(mp->cp);			/* start it */
	    cascade(mp->cp);
	    break;
	}
    }
}


/******************************************************************************
    m002init -- nothing to do
******************************************************************************/

void m002init(mp)
struct m002data	*mp;	/* data area */
{
}


/******************************************************************************
    m002reset -- nothing to do
******************************************************************************/

void m002reset(mp)
struct m002data	*mp;	/* data area */
{
}


/******************************************************************************
    m002up -- echo keyup
******************************************************************************/

void m002up(mp,ch,p)
struct m002data	*mp;	/* data area */
int				ch;		/* channel */
int				p;		/* pitch */
{

/*
gprintf(TRANS, "m002up:   ch %d, p %d\n",ch,p);
*/
}

