/* c200m000 -- algorithm 000 -- echo input */

/*
    Copyright pending, Intelligistics, Inc.

    Please see the notice in the main module associated with 
    this submodule: c200.c

*/
/*
    Revisions:

    200 -- gwl I*I 19-JUn-90 -- created
*/

/* definitions */

#include	"linterp.h"				/* macros for interpolation */
#include	"cscdef.h"				/* definitions and externals */
#include	"keydef.h"
#include	"stdio.h"
#include	"ascdef.h"				/* definitions for m000s in */
#include	"ctype.h"				/* for text routines */
#include	"string.h"


void m000send();

/******************************************************************************
    m000down -- echo keydown
******************************************************************************/

void m000down(mp,ch,p,v)
struct m000data	*mp;	/* data area */
int				ch;		/* channel */
int				p;		/* pitch */
int				v;		/* velocity */
{

/*
gprintf(TRANS, "m000down: ch %d, p %d, v %d\n",ch,p,v);
*/
    m000send(mp,ch,p,v);
}


/******************************************************************************
    m000init -- nothing to do
******************************************************************************/

void m000init(mp)
struct m000data	*mp;	/* data area */
{
}


/******************************************************************************
    m000reset -- nothing to do
******************************************************************************/

void m000reset(mp)
struct m000data	*mp;	/* data area */
{
}


/******************************************************************************
    m000send -- midi note
******************************************************************************/

void m000send(mp,ch,p,v)
struct m000data	*mp;	/* data area */
int				ch;		/* channel */
int				p;		/* pitch */
int				v;		/* velocity */
{

    int		i=0;		/* index, steps through list */
    int		nch;		/* # channels */
    int		cho;		/* output channel */
    int		ntr;		/* # transpositions */
    int		pit;		/* temporary pitch */

/*
gprintf(TRANS, "m000send: ch %d, p %d, v %d\n",ch,p,v);
*/
    nch=mp->val[i++];
    while (nch--)
    {
	cho=mp->val[i++];
	ntr=mp->val[i++];
	while (ntr--)
	{
	    if ((pit=p+mp->val[i++])>=-12 && pit<=115)
		midi_note(cho,pit,v);
	}
    }
}


/******************************************************************************
    m000up -- echo keyup
******************************************************************************/

void m000up(mp,ch,p)
struct m000data	*mp;	/* data area */
int				ch;		/* channel */
int				p;		/* pitch */
{

/*
gprintf(TRANS, "m000up:   ch %d, p %d\n",ch,p);
*/
    m000send(mp,ch,p,0);
}

