/* c200asc -- ascii event handler for c200 */

/*
    Copyright pending, Intelligistics, Inc.

    Please see the notice in the main module associated with 
    this submodule: c200.c

*/
/*
    Revisions:

    102 -- gwl I*I 20-Apr-89 -- created
    103 -- gwl I*I 10-Nov-89 -- redefine left; export
    200 -- gwl I*I 26-Nov-89 -- trace clavier keys for c200key
		   19-nov-90 -- mode supervisor
*/

/* definitions */
#include	"cmtprog.h"
#include	"cscdef.h"				/* definitions and externals */
#include	"stdio.h"
#include	"ascdef.h"				/* definitions for keys in */
#include	"ctype.h"				/* for text routines */
#include	"string.h"

FILE	*read_open(char *);

/* moxc variables */
/* NOTE: error handling has not been completely worked out in CMU MIDI TOOLKIT, so
 * we'll do some machine dependent code here.  This should be fixed up in the
 * next release.
 */
#ifdef MACINTOSH
#define SHOW_ERRORS midi_show_errors
#else
#define SHOW_ERRORS
#endif

/* external data */

static	int	got_null=0;		/* 1 <=> got first null of extended char */
static	int	text_mode=0;		/* 1 <=> building text string */
static	int	file_mode=0;		/* 1 <=> processing file name */
static	char	name[LTEXT]="";		/* file name buffer */
static	char	*text;			/* pointer to the text area being used */
static	char	*ptext;			/* pointer to where we are in text */
static	void	(*text_do)();		/* invoked when text is done */
	int	yes_mode;		/* 1 <=> waiting for y or other */
	int	(*yes_do)();		/* invoked for y (yes) response */
static	FILE	*scorep=NULL;		/* score file pointer */
static	char	score[LTEXT]="";	/* score file name */

extern	int	showdata;		/* 1=show score data */
extern	int	prtranseeds;


void rw_init();
void score_open();
void text_build();
void read_file();
void write_file();

/******************************************************************************
    process key strokes from terminal
******************************************************************************/

void asciievent(char kk /* the input character */)
{
    /* treat kk as unsigned 8 bit data */
    int k = 0xff & (int) kk;

    /* check for null before extended character */
    if (!k) {
	if(got_null) {
	    gprintf(TRANS, "asciievent: got two nulls\n");
	    got_null=0;
	} else {
	    got_null=1;
	}
	return;
    } else if (got_null) {
	got_null=0;
	k+=128;
    }

    /* check for yes/no question */

    if (yes_mode) {
	yes_mode=0;				/* turn mode off */
	if(k=='y') 
	    (*yes_do)();
	return;
    }

    /* check for building a text string */

    if (text_mode) {
	text_build(k);
	return;
    }


    /* prcess characters in command mode */

    switch (k) {

    /* read next entry in score */

    case 'n':

    if (scorep==NULL) {
	gprintf(TRANS, "Score file not open\n");
	break;
    }

    if (score_data(scorep)==EOF) {
	gprintf(TRANS, "Done %s\n",score);
	read_close(scorep,score);
	scorep=NULL;
    }
    break;

    /* open a score file */

    case 'o':

    if (scorep)
	read_close(scorep,score);
    gprintf(TRANS, "Score: ");
    rw_init();
    text_do=score_open;
    break;

    /* quit */

    case 'q':
/*
gprintf(TRANS, "\n");
*/
	gprintf(TRANS, "Next seed %ld\n",randseed);
	quit();
	break;
	
    /* read a file */

    case 'r':
	gprintf(TRANS, "Read: ");
	rw_init();				/* initialize pointers etc. */
	text_do=read_file;		/* when done */
	break;

    /* cascade title */

    case 't':
	gprintf(TRANS, "Title: ");
	text_mode=1;
	ptext=text=curcp->title;
	while (*ptext) 
	    gputchar(*ptext++);
	text_do=NULL;
	break;

    /* restore randseed from casc */

    case 'u':
	gprintf(TRANS, "Seed was %ld, now is %ld\n",randseed,curcp->ranseed);
	randseed=curcp->ranseed;
	break;

    /* write a file */

    case 'w':
	gprintf(TRANS, "Write: ");
	rw_init();				/* initialize pointers etc. */
	text_do=write_file;		/* when done */
	break;

    /* stop clusters */

    case 'x':
	stopclusters=1;
	break;

    /* stop notes */

    case 'y':
	stopnotes=1;
	stopclusters=1;			/* keep more from beng requested */
	break;

    /* restart cascade */

    case 'z':
	cascade(curcp);
	break;

    /* toggle showing ends of events */

    case '!':
    case '1':
	gprintf(TRANS, "End events %s\n",((prtendevents=1-prtendevents)?"on":"off"));
	break;

    /* toggle showing ranseeds */

    case '@':
    case '2':
	gprintf(TRANS, "Ranseeds %s\n",((prtranseeds=1-prtranseeds)?"on":"off"));
	break;

    /* show keypress data */

    case '#':
    case '3':
	m001prtdata();
	break;

    /* show variable parameters */

    case '$':
    case '4':
	m001parmdata();
	break;

    /* reset keys */

    case ' ':
	keyreset();
	if (midi_error_flags)
	{
	    SHOW_ERRORS;
	    midi_error_flags = 0;
	}
	musicinit();
	midi_thru(0);
	midi_cont(1);
	break;

    /* otherwise */

    default:
	gprintf(TRANS, "<%d> ",k);
	keyreset();

    }
}


/******************************************************************************
    prepare pointer for read or write
******************************************************************************/

void rw_init()
{
    text_mode=1;			/* we're in text mode */
    file_mode=1;			/* special processing for file name */
    ptext=text=name;		/* start at the beginning */
    while (*ptext) 
	gputchar(*ptext++);
}



/******************************************************************************
    open score file and read first entry
******************************************************************************/

void score_open(name)
char	*name;		/* score file name */
{
    /* save name */

    strcpy(score,name);

    /* open it */

    if (!(scorep=read_open(name))) {
	return;
    }

    showdata=0;							/* reset to not show */

    if ((score_data(scorep)==EOF)) {
	gprintf(TRANS, "score_open: no data in %s\n",name);
	read_close(scorep,score);
    }
}



/******************************************************************************
    accumulate text until all in
******************************************************************************/

void text_build(k)
int		k;			/* the next input character */
{
    int		i;		/* temporary */

    /* for non-printable characters, check for valid key */

    if( k<=31 || k>= 127) {

	switch (k) {

	case ESC:				/* abort */
	    text_mode=0;
	    file_mode=0;
	    gprintf(TRANS, "%c\n",BEL);
	    break;

	case RETURN: 
	case LF:				/* done with it */
	    gputchar('\n');
	    if(ptext>text) {
		*ptext='\0';	/* add a null */
		if (text_do)
		    (*text_do)(text);	/* process it */
	    } else 
		gputchar(BEL);	/* if nothing entered, only signal */
	    text_mode=0;
	    file_mode=0;
	    break;

	case Left:				/* back one space */
	    if (ptext<=text){	/* if at beginning, signal */
		gputchar(BEL);
		break;
	    }
	    gprintf(TRANS, "\b \b");	/* clear the screen spot */
	    ptext--;
	    break;

	case BS:				/* back to square zero */
	    if (ptext<=text){	/* if at beginning, signal */
		gputchar(BEL);
		break;
	    }
	    i=ptext-text;		/* clear the screen area */
	    while (i--) 
		gprintf(TRANS, "\b \b");
	    ptext=text;
	    break;

	case Right:				/* display the next character */
	    if (*ptext)			/* if one there */ 
		gputchar(*ptext++);
	    else
		gputchar(BEL);	/* otherwise signal */
	    break;

	case Up:				/* incr the last character if you can */
	    if (ptext<=text) {
		gputchar(BEL);
		break;
	    }
	    ptext--;
	    if (isdigit(*ptext)) {
		if(*ptext<'9')
		    gprintf(TRANS, "\b%c",++(*ptext));
		else
		    gputchar(BEL);
	    } else if (isalpha(*ptext)) {
		if(*ptext<'z')
		    gprintf(TRANS, "\b%c",++(*ptext));
		else
		    gputchar(BEL);
	    } else
		gputchar(BEL);
	    ptext++;
	    break;

	case Down:				/* decr the last character if you can */
	    if (ptext<=text) {
		gputchar(BEL);
		break;
	    }
	    ptext--;
	    if (isdigit(*ptext)) {
		if(*ptext>'0')
		    gprintf(TRANS, "\b%c",--(*ptext));
		else
		    gputchar(BEL);
	    } else if (isalpha(*ptext)) {
		if(*ptext>'a')
		    gprintf(TRANS, "\b%c",--(*ptext));
		else
		    gputchar(BEL);
	    } else
		gputchar(BEL);
	    ptext++;
	    break;

	default:				/* otherwise */
	    gputchar(BEL);
	}

    /* alpha for text */

    } else {

	/* file names are limited to lower case etc. */

	if (file_mode) {
	    k=tolower(k);
	    if ( (isalnum(k)||k=='.'||k=='\\'||k==':')
	      && ((ptext-text)<LTEXT-1) ){
		*ptext++=k;
		gputchar(k);
	    } else
		gputchar(BEL);

	/* regular text */

	} else if ( (ptext-text)<(LTEXT-1) ){
	    *ptext++=k;
	    gputchar(k);
	} else
	    gputchar(BEL);
    }
}
