/* c200.c -- Cascades II */

/*
    Copyright pending, Intelligistics, Inc.

    Please feel free to modify and/or use this code as you will.
    Naturally, we would appreciate your including these notices
    in any exact or modified copies you make, and your giving credit
    in program notes to those mentioned in the revision list below.

    Intelligistics offers this code "as is" and makes no claims for 
    correctness nor applicability.  In particular, Intelligistics is
    not responsible in any way for any losses or damages caused
    directly or indirectly by the software or techniques therein.

    If you wish to be included in our mailing list of updates and news,
    please send a check for $25.00 (USA) to:

		    Intelligistics, Inc.
		    Six Quarry Road
		    Simsbury, Connecticut CT 06070
		    USA

    Thank you and best wishes from us that this software is both useful
    to you and brings you pleasure.
*/
/*
    Versions:

    100 -- gwl I*I 16-Apr-89 -- original
    101 -- gwl I*I 19-Apr-89 -- ranseed, cluster organization
    102 -- gwl I*I 20-Apr-89 -- files, subroutinized
    103 -- gwl I*I 10-Nov-89 -- prepare for export
    200 -- gwl I*I 15-Jun-90 -- mods for II
		   19-Jun-90 -- mode supervisor

    Notes:

    gwl I*I = G.W.Logemann, Intelligistics, Inc.
*/

#include	"cscdef.h"
#include	"keydef.h"
#include	"alloent.h"
#include 	"stdio.h"
#include	"cmtprog.h"

char *app_syntax = "";

/* cascade parameter areas */

struct	cascval		casc[NCASCS];


/* pointer to current areas */

struct	cascval		*curcp=&casc[0];
struct	elemval		*curep;
struct	noteval		*curnp;


/* stop flags: 1=stop, 0=go */

int		stopclusters=0;				/* no further clusters */
int		stopnotes=0;				/* no further notes */

/* print flags: 1=yes, 0=no */

int		prtendevents=1;				/* show ends of events */
int		prtranseeds=1;				/* show ranseed values */


void cluster();
void event();
void seqtick();
void stop();

/******************************************************************************
    main program
******************************************************************************/

void mainscore()
{

    /* start up midi interface */

    midi_thru(0);
    /* mpu_error_check(); */

    seqtick(1000l);

    /* initialize algorithmss */

    keyinit();

    /* accept all controller data */

    midi_cont(1);

}

/* what to do when you quit... */
void coda(void)
{
}


/******************************************************************************
    compute initial values of chipt parameters
******************************************************************************/

void cascinit (cp)
struct	cascabs	*cp;		/* cascade parameters to initialize */
{
    long	initval(struct	cascval	*cp, double p);		/* computes initial values */
    int		i;

    for (i=0; i<4; i++) {
	cp->p[i].chiptmin=initval((struct cascval *) cp,cp->p[i].chipbmin);
	cp->p[i].chiptmax=initval((struct cascval *) cp,cp->p[i].chipbmax);
    }
}



/******************************************************************************
    compute initial value of note element parameter
******************************************************************************/

long
initval(cp,p)
struct	cascval		*cp;		/* cascade parameters */
double				p;			/* parameter to scale */
{
    double	temp;

    temp = p * cp->scale;
    return ( (long) (temp / cp->beat) );
}



/******************************************************************************
    do a cascade = a bunch of clusters
******************************************************************************/

void cascade(cp)
struct	cascval		*cp;		/* cascade parameters */
{

    /* initializations */

    stopclusters=0;				/* in case we restarted after a stop */
    stopnotes=0;
/*
    if (prtranseeds) gprintf(TRANS, "First seed %ld\n",randseed);
*/
    if (prtranseeds) gprintf(TRANS, "*");
    cp->ranseed=randseed;		/* save this in case we write casc */

    /* start the bunch of clusters */

    cluster(cp,cp->chanbeg,cp->nclusters*cp->ncascades);
}



/******************************************************************************
    do one of a bunch of clusters
******************************************************************************/

void cluster(cp,c,n)
struct	cascval		*cp;		/* cascade parameters */
int					c;			/* current channel */
int					n;			/* number of clusters remaining */
{

    int		i;
    double	ran();
    int		wait;

/*
gprintf(TRANS, "%d ",n);
*/

    /* skip it if none requested */

    if (n<=0) return;

    /* cancel remainder of bunch if requested */

    if(stopclusters) {
	stop();
	return;
    }

    /* do a cluster */

    for (i=0; i<cp->nevents; i++)
	event(cp,c,cp->nnotes);

    /* time of next cluster */

    wait=cp->sepabs+iran(cp->sepran);

    /* and its channel */

    if (++c>cp->chanend)
	c=cp->chanbeg;

    /* and do it */

    if (--n)
	cause(wait,cluster,cp,c,n);

}



/******************************************************************************
    do an event
******************************************************************************/

void event(cp,c,n)
struct	cascval	*cp;		/* cascade parameters */
int		c;		/* on this channel */
int		n;		/* number of notes to do */
{

    struct	noteval	*np;		/* note parameters for this event */
    int		start_val();
    void	next_note();

    /* skip it if none requested */

    if (n<=0) return;
    if(stopnotes) {
	stop();
	return;
    }

    /* set up the note area */

    alloent(np,noteval,"event",1,"note area");

    /* compute values for first note */

    np->pit=start_val(&cp->pit);
    np->dur=start_val(&cp->dur);
    np->art=start_val(&cp->art);
    np->lou=start_val(&cp->lou);

    /* start the note */

    midi_note(c,np->pit,np->lou);

    /* end the note */

    cause(np->art,midi_note,c,np->pit,0);

    /* and continue with the next */

    if (--n)
	cause(np->dur,next_note,cp,np,c,n,(long)np->dur);
    else
	free(np);
}



/******************************************************************************
    starting value
******************************************************************************/

start_val(ep)
struct	elemval		*ep;			/* parameter area for note element */
{
    int		iran();

    return(  ep->valmin + iran( ep->valmax-ep->valmin ) );
}


/******************************************************************************
    do the next note
******************************************************************************/

void next_note(cp,np,c,n,time)

struct	cascval		*cp;		/* cascade parameters */
struct	noteval		*np;		/* old note values */
int					c;			/* on this channel */
int					n;			/* number of notes remaining */
long				time;		/* current time since start of cascade */

{

    int		next_val();

    /* n should be positive */

    if (n<=0) {
	gprintf(TRANS, "next_note: bad n %d\n",n);
	return;
    }

    /* skip it if none requested */

    if(stopnotes) {
	free (np);
	stop();
	return;
    }
    /* compute values for new note */

    if (   next_val(cp,&np->pit,&cp->pit,time)
	&& next_val(cp,&np->dur,&cp->dur,time)
	&& next_val(cp,&np->art,&cp->art,time)
	&& next_val(cp,&np->lou,&cp->lou,time) ) {

	    /* if there is one, start the note */

	    midi_note(c,np->pit,np->lou);

	    /* end the note */

	    cause(np->art,midi_note,c,np->pit,0);

	    /* and continue with the next */

	    if (--n)
		cause(np->dur,next_note,cp,np,c,n,time+(long)np->dur);
	    else {
		if (prtendevents) gprintf(TRANS, "!");
		free(np);
	    }

    } else {
	if (prtendevents) gprintf(TRANS, "!");
	free (np);
    }

}


/******************************************************************************
    compute the next value of a parameter
******************************************************************************/

next_val(cp,val,p,time)
struct	cascval		*cp;		/* cascade parameters */
int					*val;		/* old value */
struct	elemval		*p;			/* parameter area */
long				time;		/* time of this parameter */

{
    int		chvalmin;		/* minimum for allowable change */
    int		chvalmax;		/* maximum  "      "        "   */
    int		chg_val;		/* computed change in value */
    long	temp;			/* temporary value for proper sequence of calcs */
    int		ret_code;		/* temporary value for ending condition */
    double	ran();

    temp=time*p->chiptmin;

    chvalmin=p->incmin+temp/cp->scale;

    temp=time*p->chiptmax;

    chvalmax=p->incmax+temp/cp->scale;

    /* compute random value between limits */

    chg_val=chvalmin + iran(chvalmax-chvalmin);

    /* compute new value and test for limits */

    *val+=chg_val;
    ret_code=1;

    if (*val < p->endmin) {
	ret_code=0;
	*val=p->endmin;
    }

    if (*val > p->endmax) {
	ret_code=0;
	*val=p->endmax;
    }

    if (p->endflag)
	return(ret_code);
    else
	return(1);
}



/******************************************************************************
    stop
******************************************************************************/

void stop()
{
/*
    if(prtranseeds) gprintf(TRANS, "Next seed %ld\n",randseed);
*/
    if(prtranseeds) gprintf(TRANS, ".");
}



/******************************************************************************
    ticker
******************************************************************************/

void seqtick(t)
long		t;		/* delay */
{
    cause((int)t,seqtick,t);
}

