/* match1.c -- a trivial match */

#include "cext.h"
#include "stdio.h"
#include "mem.h"
#include "midifns.h"
#include "userio.h"
#include "timebase.h"
#include "seq.h"
#include "evt.h"
#include "cevt.h"
#include "score.h"
#include "iter.h"
#include "sched.h"
#include "match.h"

extern boolean verbose;

char match_syntax[] = "";


match_type match_create(iter, id, sched)
  iter_type iter;
  int id;       /* what to send to sched */
  sched_type sched; /* handler for matches */
{
    match_type self = match_alloc();
    self->iter = iter;
    self->id = id;
    self->sched = sched;
    return self;
}


void match_event(self, k)
  match_type self;
  int k;
{
    set_type mem;
    evt_type evt;
    cevt_type cevt;
    boolean last_flag;

    cevt = iter_curr_cevt(self->iter);
    if (verbose) evt_show(*cevt, *(cevt+1));

    cevt_set_memberp(mem, k, cevt, evt);

    if (verbose) gprintf(TRANS, "match_event: mem %lx\n", mem);
    if (mem) {
	time_type vtime = iter_curr_time(self->iter);
	iter_set_next_cevt(cevt, self->iter, true);
	last_flag = evt_is_last(*cevt);
	if (last_flag) {
	    gprintf(TRANS, "End of score reached!  Type z to stop.\n");
	}
	 sched_match(self->sched, self->id, gettime(),
		    vtime, last_flag, iter_curr_time(self->iter));
    } else {
	sched_nomatch(self->sched, self->id, k);
    }
}


/* match_destroy -- deallocate a match */
/**/
void match_destroy(self)
  match_type self;
{
    match_free(self);
}


/* match_jump_to -- jump to a time point, return next cevt time */
/*
 * NOTE: when we reach the end of the score, last_event is set to true
 */
time_type match_jump_to(self, dest, last_flag)
  match_type self;
  time_type dest;
  boolean *last_flag;
{
    cevt_type next;

    sched_jump_to(self->sched, dest);
    iter_jump_to(self->iter, dest);
    /* the current location should be the NEXT cevt to be matched,
     *  so step ahead:
     */
    iter_set_next_cevt(next, self->iter, true);
    *last_flag = evt_is_last(*next);
    return iter_curr_time(self->iter);
}


/* match_reset -- reset a matcher and iterator to start of score */
/**/
void match_reset(self)
  match_type self;
{
    cevt_type next;

    iter_reset(self->iter);
    iter_set_next_cevt(next, self->iter, true); /* advance past initial rest */
    sched_reset(self->sched);
}
