#include "cext.h"
#include "stdio.h"
#include "userio.h"
#include "midifns.h" /* to get time_type */
#include "timebase.h"
#include "seq.h"
#include "evt.h"

private ulong DeltaTime();

/* DeltaTime -- search for time until next note event in sequence
 *
 *  It is assumed that the time of nextAdagioEvent will be
 *  greater than or equal to currTime.
 */
private ulong DeltaTime(currTime, nextAdagioEvent, ch)
  ulong currTime;
  event_type nextAdagioEvent;
  int ch;       /* the channel the score is recorded on */
{
    ulong deltaTime = 0L;

    /* find difference between currTime and the time of the next note */
    while (nextAdagioEvent != NULL) {
	if ((is_note(nextAdagioEvent)) &&
	      (nextAdagioEvent->value != NO_PITCH) &&
	      (vc_voice(nextAdagioEvent->nvoice) == ch)) {
	    /* compute the time, convert ms to cs: */
	    deltaTime = vtime_to_evt(nextAdagioEvent->ntime - currTime);
	    break;
	}
	/* loop until we find a real note or the end of the score */
	nextAdagioEvent = nextAdagioEvent->next;
    }

    if (deltaTime > (ulong) MAX_DELTA_TIME) {
	gprintf(ERROR, "(score.c): deltaTime overflow.");
	return MAX_DELTA_TIME;
    } else {
	return deltaTime;
    }
}


public void evt_show(event, end_event)
  evt_type event;
  evt_type end_event;
  /*
   *    Used for debugging. Prints the an Event in human-readable
   *    form to the transcript.  If end_event, then print pitches
   *    up to but not including end_event.
   */
{
    if (event == NULL) {
	gprintf(TRANS, "NULL event pointer.\n");
	return;
    }
    if (event->deltaTime == FIRST_FLAG) {
	gprintf(TRANS, "<First> -- initial rest time: %lu\n",
		event->u.rest.rdur);
    } else if (event->deltaTime == LAST_FLAG) {
	gprintf(TRANS, "<Last>\n");
    } else if (event->deltaTime == LREST_FLAG) {
	gprintf(TRANS, "<Long Rest> -- rest dur: %lu\n", event->u.rest.rdur);
    } else if (event->deltaTime <= MAX_DELTA_TIME) {
	gprintf(TRANS, "deltaTime: %5u", event->deltaTime);
	gprintf(TRANS, " pitchset: %4x", event->u.note.pitchset);
	gprintf(TRANS, " key: %3u", event->u.note.pitch);
	if (end_event) {
	    while (++event < end_event) {
		gprintf(TRANS, " %3u", event->u.note.pitch);
	    }
	}
	gprintf(TRANS, "\n");
    } else {
	gprintf(TRANS, "!! Unexpected value for event->deltaTime.\n");
    }
}

/* evt_make_evts -- convert adagio seq to Events array
 *
 *    WARNING: Handling the sentinals and correctly getting the
 *    Cevt array set up are tricky. If you modify this, be careful!
 *    The number of cevts in the score are returned via *cevts.
 */
evt_type evt_make_evts(seq, ch, cevts)
  seq_type seq; /* the seq to convert */
  int ch;       /* the channel (1-31) containing the part to be extracted */
  int *cevts;
{
    register event_type event = seq_eventlist(seq);
    evt_type nextEvt;
    evt_type result;
    ulong deltaTime;
    ulong delta_sum;  /* avoids cummulative roundoff error */
    int count = 0;

    *cevts = 3;   /* even a null score has first and last event.
		   * cevts is initially 3 to account for the last
		   * cevt in a non-null score, which otherwise isn't
		   * counted (because deltaTime is zero) */

    /* first count the notes on channel ch */
    while (event) {
	if (is_note(event) && event->value != NO_PITCH &&
	    vc_voice(event->nvoice) == ch) {
	    count++;
	}
	event = event->next;
    }
    event = seq_eventlist(seq); /* reset to beginning of score */

    result = (evt_type) MALLOC((count + 2) * sizeof(evt_node));
    if (!result) return NULL;

    /* first event sentinal */
    nextEvt = result;
    nextEvt->deltaTime = FIRST_FLAG;
    nextEvt->u.rest.rdur = DeltaTime(0L, event, ch);
    delta_sum = nextEvt->u.rest.rdur;
    nextEvt++;

    /* the score */
    while (event) {
	if (is_note(event) && event->value != NO_PITCH &&
	      vc_voice(event->nvoice) == ch) {
	    deltaTime = DeltaTime(evt_to_vtime(delta_sum), event->next, ch);
	    delta_sum += deltaTime;
	    nextEvt->deltaTime = deltaTime;
	    nextEvt->u.note.pitchset = 0;
	    nextEvt->u.note.pitch = event->value;
	    nextEvt->u.note.filler = 0;
	    if (deltaTime != 0) {
		/* for now, a compound event is a set of notes with
		 * a commmon starting time
		 */
		(*cevts)++;
	    }
	    nextEvt++;
	}
	event = event->next;
    }

    /* last event sentinal */
    nextEvt->u.note.pitchset = 0;
    nextEvt->deltaTime = LAST_FLAG;

    return result;
}

