/* a cevt_type is a pointer into an array of the form:
 *
 *      NULL EvtPtr EvtPtr EvtPtr ... EvtPtr NULL
 *
 * you can compute the number of compound events between two cevt's
 * events (from the same score!) using pointer arithmetic. furthermore,
 * the evt's themselves point into an array of events, so you
 * can compute the number of events in a given compound event by
 * subtracting two adjacent evt's.
 */

typedef long set_type;
#define empty_set (0L)

typedef evt_type *cevt_type;

#define cevt_hash(pitch) (1 << ((pitch) & 0xF))

cevt_type cevt_make_cevts();

set_type cevt_search();

/* cevt_set_memberp -- see if pitch is in cevt, return bitmap result
 *  and set evt (which must be a variable) to the matching evt
 */
#define cevt_set_memberp(rslt, pitch, cevt, evt) \
    if (cevt_hash(pitch) & cevt_pitchset(cevt)) \
	rslt = cevt_search(pitch, cevt, &evt); \
    else rslt = 0;

#define cevt_pitchset(cevt) ((*(cevt))->u.note.pitchset)

extern ulong i_to_s[];
#define int_to_set(i) i_to_s[(i) & 0x1F]

