import java.io.*;
import java.util.*;

public class HangmanTester {


	public static void main(String[] args) {
		play(HangmanState.NORMAL_MODE);
	}

	public static void play(int mode) {
		HangmanState hangmanState = new HangmanState(load("words.txt"));
		Scanner userInput = new Scanner(System.in);

		while (hangmanState.getFeedbackToUser().contains("-")) {
			System.out.println(hangmanState);
			String letter = userInput.nextLine();
			if (letter.length() == 1)
				hangmanState.letterGuessedByUser(letter, mode);
		}
		System.out.println(hangmanState);
	}

	public static Set<String> load(String file) {
		Scanner in;
		try {
			in = new Scanner(new File(file));
		}
		catch(IOException e) {
			throw new RuntimeException(e);
		}

		Set<String> set = new HashSet<String>();
		while (in.hasNextLine()) {
			set.add(in.nextLine());
		}
		in.close();
		return set;
	}

}
