#ifndef __TERRAINGEN_H__
#define __TERRAINGEN_H__

#define TERRAINGEN_TYPE_FBM				0x1
#define TERRAINGEN_TYPE_MULTI			0x2

#define TERRAINGEN_RANDOM_REG			0x3
#define TERRAINGEN_RANDOM_SMOOTH		0x4

#include <cmath>
#include <iostream>
#include <fstream>
#include <ctime>

using namespace std;

class TerrainGen {
public:

	TerrainGen();

	void generate(const char*,int,int);

	void setType(int);
	void setRandom(int);
	void setFrequency(double);
	void setAmplitude(double);
	void setAmplitudeDelta(double);
	void setOctaves(double);
	void setMultiOffset(double);

private:

	double fbm(double,double);
	double multi(double,double);

	double random(int,int);
	double smoothrandom(int,int);
	double cosinterp(double,double,double);
	double noise(double,double);

	int m_type,m_rand;
	double m_freq,m_amp,m_octaves,m_ampd,m_offset;
};

#endif