#include "terraingen.h"

TerrainGen::TerrainGen() : m_type(TERRAINGEN_TYPE_FBM), m_rand(TERRAINGEN_RANDOM_REG) {
	
	m_amp = 20.0;
	m_freq = 16.0;
	m_octaves = 2.0;
	m_ampd = 1.0;
	m_offset = 2.0;
}

void TerrainGen::generate(const char* outfile, int width, int height) {

	int i,j;
	int is=0,js=0;
	float val;
	FILE* ofile=NULL;

	ofile = fopen(outfile,"wb");

	fwrite(&width,sizeof(int),1,ofile);
	fwrite(&height,sizeof(int),1,ofile);
//	is = 300*random(time(NULL)%57,time(NULL)%57); js = 300*random(time(NULL)%57,time(NULL)%57);
	for (i = is; i < width+is; i++) {
		for (j = js; j < height+js; j++) {
			if (m_type == TERRAINGEN_TYPE_FBM) {
				val = (float)fbm(i,j);
				fwrite(&val,sizeof(float),1,ofile);
			}
			else {
				val = (float)multi(i,j);
				fwrite(&val,sizeof(float),1,ofile);
			}
		}
	}

	fclose(ofile);
}

double TerrainGen::fbm(double x, double y) {
	
	int i;
	double val=0;

	for (i = 0; i < (m_octaves-1); i++) {
		val += noise(x*m_freq,y*m_freq)*m_amp;
		m_amp *= m_ampd;
	}

	return val;
}

double TerrainGen::multi(double x, double y) {

	int i;
	double val=1;

	for (i = 0; i < (m_octaves-1); i++) {
		val *= m_offset*noise(x*m_freq,y*m_freq)*m_amp;
		m_amp *= m_ampd;
	}

	return val;
}

double TerrainGen::noise(double x, double y) {

	int x_i = (int)x, y_i = (int)y;
	double x_d = x-x_i, y_d = y-y_i;
	double v1,v2,v3,v4,i1,i2;

	if (m_rand == TERRAINGEN_RANDOM_REG) {
		v1 = random(x_i,y_i);
		v2 = random(x_i+1,y_i);
		v3 = random(x_i,y_i+1);
		v4 = random(x_i+1,y_i+1);
	}
	else {
		v1 = smoothrandom(x_i,y_i);
		v2 = smoothrandom(x_i+1,y_i);
		v3 = smoothrandom(x_i,y_i+1);
		v4 = smoothrandom(x_i+1,y_i+1);
	}

	i1 = cosinterp(v1,v2,x_d);
	i2 = cosinterp(v3,v4,x_d);

	return cosinterp(i1,i2,y_d);

}

double TerrainGen::cosinterp(double x, double y, double z) {

	double ft,f;

	ft = z*3.1415927;
	f = (1-cos(ft))*0.5;

	return (x*(1-f) + y*f);
}

double TerrainGen::smoothrandom(int x, int y) {

	double corners,sides,center;

	corners = (random(x-1,y-1)+random(x+1,y-1)+random(x-1,y+1)+random(x+1,y+1))/16.0;
	sides = (random(x-1,y)+random(x+1,y)+random(x,y-1)+random(x,y+1))/8.0;
	center = random(x,y)/4.0;

	return (corners+sides+center);
}

double TerrainGen::random(int x, int y) {

	int n;

	n = x+y*57;
	n = (n<<13)^n;

	return (1.0-((n*(n*n*19417 + 189851) + 4967243) & 4945007) / 3354521.0);

}

void TerrainGen::setAmplitude(double amp) {
	m_amp = amp;
}

void TerrainGen::setAmplitudeDelta(double ampd) {
	m_ampd = ampd;
}

void TerrainGen::setFrequency(double freq) {
	m_freq = freq;
}	

void TerrainGen::setOctaves(double octaves) {
	m_octaves= octaves;
}

void TerrainGen::setType(int type) {
	m_type = type;
}

void TerrainGen::setMultiOffset(double offset) {
	m_offset = offset;
}

void TerrainGen::setRandom(int rand) {
	m_rand = rand;
}