#ifndef __TERRAINDEMO_H__
#define __TERRAINDEMO_H__

#include "optic.h"
#include "renderer/renderer.h"
#include "core/demo.h"
#include "graphics/terrain.h"
#include "graphics/skybox.h"
#include "graphics/mesh.h"

class TerrainDemo : public Demo {
public:

	TerrainDemo();

	virtual void init();

	virtual void update(op_float);
	virtual void render();

	virtual string getName();

private:

	void init_graphics();
	void init_input();

	Renderer* m_rend;
	Terrain* m_terrain;
	Vector m_eyepos;
	VertexShader* m_shader;
	PixelShader* m_pshader;
	Font* m_font;
	Texture* m_textures[10];
	SkyBox* m_skybox;
	Mesh* m_lsphere;

	op_float m_lrot;
	int m_rendermode;
	int m_forthrot,m_backthrot,m_w,m_mousepos;
};

#endif