#include "terraindemo.h"

TerrainDemo::TerrainDemo() : m_terrain(NULL),m_lrot(0) {

	m_eyepos = Vector(0,150,300);
	m_rendermode = RND_MODE_FILL;

	m_custrender = true;
}

void TerrainDemo::init() {

	Demo::init();

	init_graphics();
	init_input();
}

void TerrainDemo::init_graphics() {

	BuildParameters* bps[3];

	ACQUIRE_RENDERER(m_rend,g_engine)

	m_entman->getGeometry()->getViewer()->getCamera()->lookat(m_eyepos,Vector(-1,60,0),Vector(0,1,0));
	
	m_textures[0] = m_dman->create2DMipmap("ccTerrainmap.tga");
	m_textures[2] = m_dman->create2DMipmap("majestic_0.tga");
	m_textures[3] = m_dman->create2DMipmap("majestic_1.tga");
	m_textures[4] = m_dman->create2DMipmap("majestic_2.tga");
	m_textures[5] = m_dman->create2DMipmap("majestic_3.tga");
	m_textures[6] = m_dman->create2DMipmap("majestic_4.tga");
	m_textures[7] = m_dman->create2DMipmap("majestic_5.tga");
	m_textures[8] = m_dman->create2DMipmap("miors_inv.tga");
	m_textures[9] = m_dman->createCubeMap("c:/optic/data/textures/cubemap/majestictga");

	// Build Sphere
	m_lsphere = (Mesh*) m_entman->create("sphere");
	m_lsphere->getMaterial()->addTexture(m_textures[8]);
	m_lsphere->getMaterial()->addTexture(m_textures[9]);
	m_lsphere->getOrientation()->scale(Vector(10,10,10));
	m_lsphere->setVertexShader(m_dman->getStoredVertexShader(DMAN_VTXSHADER_CUBEMAPONLY));
	
	// Build Terrain
	m_terrain = (Terrain*) m_entman->create("terrain",false);
	m_terrain->getMaterial()->setDiffuse(Triple(.8f,.8f,.8f));
	m_terrain->getMaterial()->addTexture(m_textures[0]);
	m_terrain->getFog()->setType(FOG_TYPE_VOLUMETRIC);
	m_terrain->getFog()->setColor(Vector(0.8f,0.8f,0.8f));
	m_terrain->getFog()->setDensity(0.00008f);
	m_terrain->setFogBias(0.25f);
	m_terrain->getOrientation()->rotate_euler(-90,0,0);
	bps[0] = new TerrainBuildParameters();
	((TerrainBuildParameters*)bps[0])->filename = g_configman->getFile("terrain.ter").c_str(); 
	((TerrainBuildParameters*)bps[0])->width = 2000; 
	((TerrainBuildParameters*)bps[0])->height = 2000; 
	((TerrainBuildParameters*)bps[0])->step = 12.0f;
	m_terrain->build(bps[0]);
	m_shader = m_dman->createVertexShader("terrain.vsd");
	m_shader->setConstant(20,m_lsphere->getOrientation()->getPosition());
	m_shader->setConstant(21,Vector(0.0f,0.0f,0.0f,0.0f));
	m_shader->setConstant(22,Vector(0,0,0,0));
	m_shader->setConstant(23,Vector(0,100,230,1));
	m_shader->setConstant(24,Vector(1,0.008f,m_terrain->getMaxHeight(),-1));
	m_shader->setConstant(25,Vector(m_terrain->getFog()->getNear(),m_terrain->getFog()->getFar(),m_terrain->getFog()->getDensity(),1));
	m_pshader = m_dman->createPixelShader("terrain_twofog.fsd");	
//	m_terrain->setPixelShader(m_pshader);
	m_terrain->setVertexShader(m_shader);
	m_entman->getGeometry()->insert(m_terrain,true,false);

	// Build Skybox
	m_skybox = (SkyBox*) m_entman->create("skybox",false);
	m_skybox->getMaterial()->addTexture(m_textures[2]);
	m_skybox->getMaterial()->addTexture(m_textures[3]);
	m_skybox->getMaterial()->addTexture(m_textures[4]);
	m_skybox->getMaterial()->addTexture(m_textures[5]);
	m_skybox->getMaterial()->addTexture(m_textures[6]);
	m_skybox->getMaterial()->addTexture(m_textures[7]);
	bps[2] = new SkyBoxBuildParameters();
	((SkyBoxBuildParameters*)bps[2])->height = 1000;
	((SkyBoxBuildParameters*)bps[2])->width = 1000;
	((SkyBoxBuildParameters*)bps[2])->depth = 1000;
	m_skybox->build(bps[2]);
	m_skybox->getOrientation()->translate(Vector(0,400,0));
	m_entman->getGeometry()->insert(m_skybox,true,false);

	m_font = m_dman->getStoredFont(DMAN_FONT_TNR14B);
}

void TerrainDemo::render() {

	m_entman->getGeometry()->render();

	m_rend->text(10,10,m_font,"FPS: %.1f",m_timer->getFPS());
	m_rend->text(10,20,m_font,"Terrain Engine");
	m_rend->text(10,30,m_font,"w/ Terrain Shader for Volumetric Fog");

}

void TerrainDemo::update(op_float dt) {
	
	Orientation rot(m_rend->getCamera());

	if (m_input->pollChannel(m_forthrot).m_button_down[0])
		m_entman->getGeometry()->getViewer()->getCamera()->moveOnView(100.0f*dt);
	if (m_input->pollChannel(m_backthrot).m_button_down[0])
		m_entman->getGeometry()->getViewer()->getCamera()->moveOnView(-100.0f*dt);
	
	if (!m_input->pollChannel(m_mousepos).m_button_down[0])
		m_rend->setFillMode(RND_MODE_FILL);
	else
		m_rend->setFillMode(RND_MODE_WIREFRAME);

	m_lrot += 1.0f*dt;
	m_lsphere->getOrientation()->translate(Vector(150.0f*cos(m_lrot),100,150.0f*sin(m_lrot)));

	rot.rotate_axisangle(Vector(1,1,0),40.0f*dt);
	m_lsphere->getOrientation()->compose(&rot);

	m_shader->setConstant(20,m_lsphere->getOrientation()->getPosition());
	m_shader->setConstant(23,m_entman->getGeometry()->getViewer()->getCamera()->getEyePoint());
}

void TerrainDemo::init_input() {
	
	InputDevice* keyboard,*mouse;
	vector<int> mouse_channels;

	keyboard = m_input->getCommonDevice(INPUT_COMMON_KEYBOARD);
	mouse = m_input->getCommonDevice(INPUT_COMMON_MOUSE);
	m_forthrot = m_input->newInputChannel();
	m_backthrot = m_input->newInputChannel(); 
	m_input->addInputChannel(m_forthrot,keyboard,DIK_UP);
	m_input->addInputChannel(m_backthrot,keyboard,DIK_DOWN);

	m_input->getChannels(mouse_channels,mouse);
	m_mousepos = mouse_channels[0];

	m_entman->getGeometry()->getViewer()->getCamera()->lockToTrackball(m_mousepos);
}

string TerrainDemo::getName() {
	
	return "Terrain Engine Demo";
}