// Mike Maxim
// Vector math
// Persistent as possible (SML has taught me something...)

#ifndef __VECTOR_H__
#define __VECTOR_H__

#include <string>
#include <strstream>
#include <cmath>

typedef float	OBJfloat;

using namespace std;

class Vector {
public:
	
	Vector() { v[0]=0.0; v[1] = 0.0; v[2] = 0.0; v[3] = 0.0f; }
	Vector(OBJfloat x, OBJfloat y, OBJfloat z) { v[0]=x; v[1]=y; v[2]=z; }
	Vector(OBJfloat x, OBJfloat y, OBJfloat z, OBJfloat w) { v[0]=x; v[1]=y; v[2]=z; v[3]=w; }
	Vector(OBJfloat* vp);
	Vector(const Vector&);
	
	Vector& operator =(const Vector&);
	
	OBJfloat& operator[] (int);
	OBJfloat operator[] (int) const;
	
	friend OBJfloat operator * (const Vector&,const Vector&);
	
	friend Vector operator * (const Vector&,OBJfloat);
	friend Vector operator * (OBJfloat, const Vector&);
	
	Vector& operator *=(OBJfloat);
	
	friend Vector operator + (const Vector&,const Vector&);
	Vector& operator += (const Vector&);
	
	friend Vector operator - (const Vector&,const Vector&);
	Vector& operator -= (const Vector&);
	
	Vector fill(OBJfloat) const;
	Vector cross(const Vector&) const;
	Vector normalize() const;
	OBJfloat mag() const;
	Vector negate() const;

	void getVect(OBJfloat*) const;
	string toString() const;
	
private:
	
	void copy(const Vector&);
	
	OBJfloat v[4];
	
};

#endif
