// Mike Maxim
// Vector implementation

#include "vector.h"

// Init routines
Vector::Vector(OBJfloat* vp) {
	
	int i;
	for (i = 0; i < 4; i++)
		v[i]=vp[i];
	
}

Vector::Vector(const Vector& vp) {
	copy(vp);
}

Vector& Vector::operator =(const Vector& v) {
	
	if (&v != this)
		copy(v);
	
	return *this;
}

// Copy
void Vector::copy(const Vector& vp) {
	
	int i;
	for (i = 0; i < 4; i++)
		v[i]=vp[i];
}

// Access
OBJfloat& Vector::operator[] (int index) {
	
	return v[index];
	
}

OBJfloat Vector::operator[] (int index) const {
	
	return v[index];
}

// Dot product
OBJfloat operator * (const Vector& left, const Vector& right) {
	
	return left[0]*right[0]+left[1]*right[1]+left[2]*right[2];
	
}

// Scalar multiplication
Vector operator * (const Vector& left, OBJfloat s) {
	
	Vector result;
	
	result[0] = left[0]*s;
	result[1] = left[1]*s;
	result[2] = left[2]*s;
	
	return result;
}

Vector operator * (OBJfloat s, const Vector& right) {
	return right*s;
}

// Scalar mult
Vector& Vector::operator *= (OBJfloat s) {
	
	*this = (*this)*s;
	
	return *this;
}

// Addition
Vector operator + (const Vector& left, const Vector& right) {
	
	Vector result;
	
	result[0] = left[0]+right[0];
	result[1] = left[1]+right[1];
	result[2] = left[2]+right[2];
	
	return result;
}

// Addition
Vector& Vector::operator += (const Vector& right) {
	
	*this = *this + right;
	
	return *this;
	
}

// Subtraction
Vector operator - (const Vector& left, const Vector& right) {
	
	Vector result;
	
	result[0] = left[0]-right[0];
	result[1] = left[1]-right[1];
	result[2] = left[2]-right[2];
	
	return result;
}

Vector& Vector::operator -= (const Vector& right) {
	
	*this = *this - right;
	
	return *this;
	
}

// Cross Product
Vector Vector::cross(const Vector& vp) const {
	
	Vector c;
	
	c[0] = v[1]*vp[2]-v[2]*vp[1];
	c[1] = v[2]*vp[0]-v[0]*vp[2];
	c[2] = v[0]*vp[1]-v[1]*vp[0];
	
	return c;
}

Vector Vector::fill(OBJfloat f) const {
	
	Vector v;
	
	v[0]=f; v[1]=f; v[2]=f;
	
	return v;
}

// Get array version
void Vector::getVect(OBJfloat* vp) const {
	
	vp[0] = v[0];
	vp[1] = v[1];
	vp[2] = v[2];
	
}

// Normalize the vector
Vector Vector::normalize() const {
	
	Vector n = *this;
	
	OBJfloat length;
	
	length = (OBJfloat)sqrt((n.v[0]*n.v[0]) + (n.v[1]*n.v[1]) + (n.v[2]*n.v[2]) + (n.v[3]*n.v[3]));
	if(length == 0.0)
		length = 1.0;
	
	n.v[0] /= length;
	n.v[1] /= length;
	n.v[2] /= length;
	n.v[3] /= length;

	return n;
}

// Magnitude
OBJfloat Vector::mag() const {
	
	return (OBJfloat)sqrt((v[0]*v[0]) + 
		(v[1]*v[1]) +
		(v[2]*v[2]));
}

Vector Vector::negate() const {

	Vector negation;

	negation[0] = -v[0];
	negation[1] = -v[1];
	negation[2] = -v[2];

	return negation;
}

// Printable string form
string Vector::toString() const {
	
	char buffer[256];
	
	sprintf(buffer,"[%f,%f,%f]",v[0],v[1],v[2]);
	
	return string(buffer);
	
}
