#ifndef __QUATERNION_H__
#define __QUATERNION_H__

#include <math.h>
#include "matrix.h"

#define	DEGTORAD(x)				( ((x) * 3.1415927) / 180.0f )
#define	RADTODEG(x)				( ((x) * 180.0) / 3.1415927 )

typedef float					op_float;

class Quaternion {
public:

	Quaternion();
	Quaternion(const Quaternion&);
	Quaternion& operator=(const Quaternion&);

	bool operator == (const Quaternion&) const;
	friend Quaternion operator *(const Quaternion&, const Quaternion&);
	friend Quaternion operator +(const Quaternion&, const Quaternion&);

	op_float& operator[] (int);
	op_float operator[] (int) const;

	void rotation(op_float, const Vector&);
	void getAxisAngle(op_float&,Vector&);

	op_float dot(const Quaternion&) const;

	op_float norm() const;
	Quaternion normalize() const;
	Quaternion conjugate() const;
	Quaternion negate() const;

	Quaternion slerp(const Quaternion&,const Quaternion&, op_float) const;

	void toMatrix(Matrix&);

private:

	void copy(const Quaternion&);

	op_float m_c[4];

};

#endif