// Mike Maxim
// Matrix math definition

#ifndef MATRIX_H__
#define MATRIX_H__

#include "vector.h"
#include <iostream>

using namespace std;

class Matrix {
public:
	
	Matrix(int m=2, int n=2);
	~Matrix();
	Matrix(const Matrix&);
	
	Matrix& operator=(OBJfloat);
	Matrix& operator=(const Matrix&);
	
	OBJfloat* operator[](int i) { return matrix[i]; }
	const OBJfloat* operator[](int i) const { return matrix[i]; }
	
	friend Matrix operator*(const Matrix&,const Matrix&);
	friend Matrix operator-(const Matrix&,const Matrix&);
	friend Vector operator*(const Matrix&,const Vector&);
	friend Matrix operator*(double,const Matrix&);
	friend ostream& operator << (ostream&,const Matrix&);
	
	void fromGLmatrix(OBJfloat*);
	void toGLmatrix(OBJfloat*) const;
	Matrix transpose();
	
	int rows() const { return m_rows; } 
	int cols() const { return m_cols; } 

	string toString();
	
private:
	
	void kill();
	void copy(const Matrix&);
	
	OBJfloat** matrix;
	int m_rows,m_cols;
	
};

#endif
