// Mike Maxim
// Matrix implementation

#include "matrix.h"

// Init up a mxn matrix with 0's
Matrix::Matrix(int m, int n) {
	
	int i,j;
	
	matrix = (OBJfloat**) new OBJfloat[m];
	
	for (i = 0; i < m; i++) {
		matrix[i] = new OBJfloat[n];
		
		for (j = 0; j < n; j++)
			matrix[i][j] = 0;
	}
	
	m_rows = m; m_cols = n;
}

// Kill it
Matrix::~Matrix() {
	
	kill();
	
}

// Copy it
Matrix::Matrix(const Matrix& m) {
	
	copy(m);
	
}

// Assignement operator
Matrix& Matrix::operator =(const Matrix& m) {
	
	if (this != &m) {
		
		kill();
		copy(m);
		
	}
	
	return *this;
	
}

// Delete up all dynamic memory
void Matrix::kill() {
	
	int i;
	
	for (i = 0; i < m_rows; i++) {
		delete [] matrix[i];
		matrix[i] = NULL;
	}
	
	delete [] matrix;
	matrix = NULL;
	
}

// C++ copying is a pain...
void Matrix::copy(const Matrix& m) {
	
	int i,j;
	
	m_rows = m.m_rows; m_cols = m.m_cols;
	
	matrix = (OBJfloat**) new OBJfloat[m_rows];
	for (i = 0; i < m_rows; i++)
		matrix[i] = new OBJfloat[m_cols];
	
	for (i = 0; i < m_rows; i++)
		for (j = 0; j < m_cols; j++)
			matrix[i][j] = m.matrix[i][j];
		
}

// Set every entry in the matrix to val
Matrix& Matrix::operator = (OBJfloat val) {
	
	int i,j;
	
	for (i = 0; i < m_rows; i++)
		for (j = 0; j < m_cols; j++)
			matrix[i][j] = val;
		
		return *this;
}

// Matrix multiplication
Matrix operator*(const Matrix& A, const Matrix& B) {
	
	int vsize = B.rows();
	int i,j,k;
	
	Matrix prod(A.rows(),B.cols());
	
	for (i = 0; i < A.rows(); i++) {
		for (j = 0; j < B.cols(); j++) {
			
			for (k = 0; k < vsize; k++)
				prod[i][j] += A[i][k]*B[k][j];
			
		}
	}
	
	return prod;
	
}

// Matrix - Vector product - useful for linear transformations
Vector operator*(const Matrix& A,const Vector& v) {
	
	Vector x;
	int row,col;
	
	for (row = 0; row < A.rows(); row++) {  
		for (col = 0; col < A.cols(); col++) {
			x[row] += A[row][col]*v[col];
		}
	}
	
	return x;
}

// Scalar multiplication
Matrix operator*(double scalar, const Matrix& A) {
	
	Matrix B(A.rows(),A.cols());
	int i,j;
	
	for (i = 0; i < A.rows(); i++)
		for (j = 0; j < A.cols(); j++)
			B[i][j] = scalar*A[i][j];
		
		return B;
}

// Matrix subtraction
Matrix operator-(const Matrix& A, const Matrix& B) {
	
	Matrix C(A.rows(),A.cols());
	int i,j;
	
	for (i = 0; i < A.rows(); i++)
		for (j = 0; j < A.cols(); j++)
			C[i][j] = A[i][j] - B[i][j];
		
		return C;
}

// Output matrix to a stream
ostream& operator << (ostream& os, const Matrix& m) {
	
	int i,j;
	
	for (i = 0; i < m.m_rows; i++) {
		for (j = 0; j < m.m_cols; j++)
			os << m.matrix[i][j] << " ";
		os << endl;
	}
	
	return os;
}

// Transpose the matrix
Matrix Matrix::transpose() {
	
	Matrix m_t(m_cols,m_rows);
	int i,j;
	
	for (i = 0; i < m_rows; i++)
		for (j = 0; j < m_cols; j++)
			m_t[j][i] = matrix[i][j];
		
		return m_t;
}

void Matrix::fromGLmatrix(OBJfloat* glmatrix) {
	
	matrix[0][0]=glmatrix[0]; matrix[1][0]=glmatrix[1]; matrix[2][0]=glmatrix[2]; matrix[3][0]=glmatrix[3]; 
	matrix[0][1]=glmatrix[4]; matrix[1][1]=glmatrix[5]; matrix[2][1]=glmatrix[6]; matrix[3][1]=glmatrix[7];
	matrix[0][2]=glmatrix[8]; matrix[1][2]=glmatrix[9]; matrix[2][2]=glmatrix[10]; matrix[3][2]=glmatrix[11];
	matrix[0][3]=glmatrix[12]; matrix[1][3]=glmatrix[13]; matrix[2][3]=glmatrix[14]; matrix[3][3]=glmatrix[15];

}

void Matrix::toGLmatrix(OBJfloat* glmatrix) const {

	glmatrix[0]=matrix[0][0]; glmatrix[1]=matrix[1][0]; glmatrix[2]=matrix[2][0]; glmatrix[3]=matrix[3][0];
	glmatrix[4]=matrix[0][1]; glmatrix[5]=matrix[1][1]; glmatrix[6]=matrix[2][1]; glmatrix[7]=matrix[3][1];
	glmatrix[8]=matrix[0][2]; glmatrix[9]=matrix[1][2]; glmatrix[10]=matrix[2][2]; glmatrix[11]=matrix[3][2];
	glmatrix[12]=matrix[0][3]; glmatrix[13]=matrix[1][3]; glmatrix[14]=matrix[2][3]; glmatrix[15]=matrix[3][3];

}

string Matrix::toString() {

	int i,j;
	string str,tmp;
	strstream sstr;

	for (i = 0; i < m_rows; i++) {
		str += "[ ";
		for (j = 0; j < m_cols; j++) {
			sstr << matrix[i][j];
			sstr >> tmp;
			str += (tmp + " " );
			sstr.clear();
		}
		str += "]\n";
	}

	return str;
}
