#include "logger.h"

Logger::Logger() : m_enabled(false) {


}

Logger::~Logger() {
	
	close();
}

void Logger::enable() {
	m_enabled=true;
}

void Logger::disable() {
	m_enabled=false;
}

void Logger::open() {

	m_file.open(LOGGER_FILE);
	m_file.clear();
}

void Logger::close() {

	m_file.close();

}

void Logger::writeLine(const string& line) {

	if (m_enabled)
		m_file << line << endl;

}
