#ifndef __WINDOW_H__
#define __WINDOW_H__

#include "../optic.h"
#include "../core/callback.h"
#include "defs.h"
#include "viewer.h"

class WindowCreationException : public Exception {
public:

	WindowCreationException() : Exception("Window Creation Failed") { }
	WindowCreationException(const string& m) : Exception("Window Creation Failure: " + m) { }

};

class FullScreenException : public Exception {
public:

	FullScreenException() : Exception("Fullscreen Mode Failed") { }
	FullScreenException(const string& m) : Exception("Fullscreen Mode Failed: " + m) { }	
};

class Window {
public:

	Window();

	virtual void create(const char*,op_rect,int,bool)=0;

	virtual void registerCallback(UINT,Callback*);
	virtual void destroy()=0;
	virtual void show()=0;
	virtual void hide()=0;
	virtual void caption(const char*)=0;

	Viewer* getViewer();
	Frustum* getLastFrustum();
	HWND getWin32Handle();

	virtual void resize(int,int)=0;
	virtual void fullscreen(bool)=0;
	virtual bool isFullscreen()=0;

	virtual void showframebuffer()=0;

protected:

	HWND m_hWnd;
	Viewer* m_viewer;
	Frustum* m_frustum;
	map<UINT, vector<Callback*> > m_callbacks;
};

#endif