#ifndef __VTXSHADER_H__
#define __VTXSHADER_H__

#include "../optic.h"
#include "defs.h"

#define VTXSHADER_TRANS_IDENTITY			0x20001
#define VTXSHADER_TRANS_INVERSE				0x20002
#define VTXSHADER_TRANS_INVERSETRANSPOSE	0x20003

class InvalidShaderException : public Exception {
public:

	InvalidShaderException() : Exception("Invalid Vertex Shader Specified") { }
	InvalidShaderException(const string& s) : Exception("Invalid Vertex Shader Specified" + s) { }

};

class VertexShader {
public:

	VertexShader() { }

	virtual void enable()=0;
	virtual void disable()=0;

	virtual void execute(op_float*)=0;

	virtual void load(const char*)=0;

	virtual void trackMatrix(int,int,int)=0;
	virtual void setConstant(int,const Vector&)=0;
};

#endif