#ifndef __VIEWER_H__
#define __VIEWER_H__

#include "../optic.h"
#include "defs.h"
#include "frustum.h"

#define VIEWER_MODE_ORTHO				0x100000
#define VIEWER_MODE_PERSPECTIVE			0x100001

class Viewer {
public:

	Viewer();

	virtual void ortho(op_float,op_float,op_float,op_float,op_float,op_float)=0;
	virtual void perspective(Frustum*)=0;

	virtual void setViewport(op_rect);
	virtual op_rect getViewport();

	virtual int getProjectionMode();

protected:

	op_rect m_viewport;
	int m_projmode;

};

#endif