#ifndef __VERTEXARRAY_H__
#define __VERTEXARRAY_H__

#include "../optic.h"
#include "defs.h"

#define VTXARRAY_TYPE_TRIANGLES		0xE001
#define VTXARRAY_TYPE_QUADS			0xE002

class VertexArray {
public:

	VertexArray();

	virtual void execute(int)=0;

	virtual void setVertexPointer(op_float*);
	virtual void setNormalPointer(op_float*);
	virtual void setTexturePointer(int,op_float*);
	virtual void setIndexPointer(int,UINT*);

	virtual void destroyBuffers();

protected:

	op_float* m_vertices;
	op_float* m_normals;
	op_float* m_texcoords[20];
	UINT* m_indices;
	int m_numindices;
};

#endif