#include "vertexarray.h"

VertexArray::VertexArray() : m_vertices(NULL), m_normals(NULL) {
	
	int i;
	for (i = 0; i < 20; i++)
		m_texcoords[i]=NULL;
}

void VertexArray::setVertexPointer(op_float* vertices) {
	m_vertices = vertices;
}

void VertexArray::setNormalPointer(op_float* normals) {
	m_normals = normals;
}

void VertexArray::setTexturePointer(int unit,op_float* texcoords) {
	m_texcoords[unit] = texcoords;
}

void VertexArray::setIndexPointer(int numindex, UINT* indices) {
	m_numindices = numindex;
	m_indices = indices;
}

void VertexArray::destroyBuffers() {

	int i;

	if (m_vertices != NULL)
		delete [] m_vertices;
	
	if (m_normals != NULL)
		delete [] m_normals;

	for (i = 0; i < 20; i++) {
		if (m_texcoords[i] != NULL) {
			delete [] m_texcoords[i];
			m_texcoords[i] = NULL;
		}
	}

	m_vertices = NULL;
	m_normals = NULL;

}