/** @Description Vertex wrapper, contains all necessary info to render
  * @Author Mike Maxim
  */

#ifndef __VERTEX_H__
#define __VERTEX_H__

#include "../optic.h"
#include "defs.h"
#include "material.h"

class Vertex {
public:

	Vertex();
	Vertex(const Vertex&);
	virtual ~Vertex();

	Vertex& operator=(const Vertex&);

	Vector m_position,m_normal;
	op_float m_fogcoord;
	vector<Vector> m_texcoords;
	Material* m_material;

	string toString() const;
	
private:

	void copy(const Vertex&);
};

#endif