#include "vertex.h"

Vertex::Vertex() : m_fogcoord(0.0f) { 
	m_material = NULL;
}	

Vertex::Vertex(const Vertex& vert) {
	copy(vert);
}

Vertex& Vertex::operator =(const Vertex& vert) {

	if (&vert != this) {
		copy(vert);
	}	

	return *this; 
}

Vertex::~Vertex() {

	m_texcoords.clear();

/*	if (m_material != NULL) {
		delete m_material;
		m_material = NULL;
	}*/
}

void Vertex::copy(const Vertex& vert) {

	int i;

	m_texcoords.clear();

	m_fogcoord = vert.m_fogcoord;
	m_position = vert.m_position;
	m_normal = vert.m_normal;
	m_material = vert.m_material;

/*	if (vert.m_material != NULL) 
		m_material = vert.m_material->clone();
	else
		m_material = NULL;*/

	for (i = 0; i < vert.m_texcoords.size(); i++) {
		m_texcoords.push_back(vert.m_texcoords[i]);
	}

}

string Vertex::toString() const {

	string svert;
	int i;

	svert = "P:" + m_position.toString() + " N:" + m_normal.toString() + " T:";
	for (i = 0; i < m_texcoords.size(); i++) {
		svert += m_texcoords[i].toString();
	}

	return svert; 
}