#ifndef __TRANSFORMER_H__
#define __TRANSFORMER_H__

#include "../optic.h"
#include "defs.h"

// Matrix Modes
#define TRANS_MATRIX_WORLD			0x10001
#define TRANS_MATRIX_PROJECTION		0x10002
#define TRANS_MATRIX_TEXTURE		0x10003
#define TRANS_MATRIX_COMPOSITE		0x10004

// Axes
#define TRANS_AXIS_X				0x20001
#define TRANS_AXIS_Y				0x20002
#define TRANS_AXIS_Z				0x20003

class Transformer {
public:

	Transformer() { }

	// Transformations
	virtual void rotate(int,op_float)=0;
	virtual void rotate_axisangle(op_float,const Vector&)=0;
	virtual void translate(const Vector&)=0;
	virtual void scale(const Vector&)=0;
	virtual void mult(const Matrix&)=0;
	virtual void lookat(const Vector&, const Vector&, const Vector&)=0;
	virtual void identity()=0;

	// State
	virtual void bind(int)=0;
	virtual void getCurrentMatrix(Matrix&)=0;

	virtual void push()=0;
	virtual void pop()=0;

	virtual void persist()=0;
	virtual void restore()=0;

};

#endif