#ifndef __TEXTURECOMBINER_H__
#define __TEXTURECOMBINER_H__

#include "../optic.h"
#include "defs.h"

#define TEXTURE_COMBINER_VERSION_1_0	0

class InvalidCombinerScriptException : public Exception {
public:

	InvalidCombinerScriptException() : Exception("Invalid Texture Combiner Script") { }
	InvalidCombinerScriptException(const string& s) : Exception("Invalid Texture Combiner Script: " + s) { }
};

class TextureCombiner {
public:

	TextureCombiner();

	virtual void loadScript(const char*)=0;

	virtual void enable()=0;
	virtual void disable()=0;

protected:

	vector<string> m_knownversions;
};

#endif