/** @Description Texture definition
  * @Author Mike Maxim
  */

#ifndef __TEXTURE_H__
#define __TEXTURE_H__

#include "../optic.h"
#include "defs.h"

// Type Flags
#define TEXTURE_TYPE_2D				0x300
#define TEXTURE_TYPE_2DMIPMAP		0x301
#define TEXTURE_TYPE_3D				0x302
#define TEXTURE_TYPE_CUBEMAP		0x303
#define TEXTURE_TYPE_RENDER			0x304

#define TEXTURE_COMBINE_MODULATE	0xA01
#define TEXTURE_COMBINE_DECAL		0xA02
#define TEXTURE_COMBINE_BLEND		0xA03
#define TEXTURE_COMBINE_ADD			0xA04

// Filter flags
#define TEXTURE_FILTER_BILINEAR		0x500
#define TEXTURE_FILTER_TRILINEAR	0x501

// Tex Coord Types
#define TEXTURE_COORD_S				0x001
#define TEXTURE_COORD_T				0x002
#define TEXTURE_COORD_R				0x004

// Wrap Flags
#define TEXTURE_WRAP_CLAMP			0x700
#define TEXTURE_WRAP_REPEAT			0x701
#define TEXTURE_WRAP_EDGECLAMP		0x702

// Texture Generation
#define TEXTURE_GEN_MANUAL			0x901
#define TEXTURE_GEN_SPHEREMAP		0x902
#define TEXTURE_GEN_OBJECTLINEAR	0x903
#define TEXTURE_GEN_EYELINEAR		0x904
#define TEXTURE_GEN_CUBEMAP			0x905

class InvalidTextureException : public Exception {
public:

	InvalidTextureException() : Exception("Invalid Texture Specified") { }
	InvalidTextureException(const string& m) : Exception("Invalid Texture: " + m) { }
};

class Texture {
public:

	Texture();

	virtual void bind()=0;
	virtual void create(const char*,int)=0; // Cubemaps must have same name then

	virtual void setFilter(int);
	virtual int getFilter();
	virtual void setCombineMode(int);
	virtual int getCombineMode();

	virtual void setWrapMode(int,int);
	virtual void setTexGen(int,int);
	virtual int getTexGen(int);


	virtual void load(const char*);

	virtual int getType();
	virtual int getID();
	virtual int getHeight();
	virtual int getWidth();
	virtual int getBPP();
	virtual int getImageSize();
	virtual string getName();
	virtual op_byte* getData();

	virtual void setID(int);

protected:

	void loadTGA(const char*);

	op_byte* m_data;
	int m_height,m_width,m_bpp,m_imagesize;
	UINT m_id;
	int m_filter,m_type,m_combine;
	int m_wrap[5],m_texgen[5];
	string m_name;
};

#endif