#include "texture.h"

Texture::Texture() : m_id(0), m_data(NULL), m_height(0), m_width(0) { 
	
	m_filter = TEXTURE_FILTER_BILINEAR;

	m_type = TEXTURE_TYPE_2D;
	m_combine = TEXTURE_COMBINE_MODULATE;

	m_wrap[TEXTURE_COORD_S] = TEXTURE_WRAP_REPEAT;
	m_wrap[TEXTURE_COORD_T] = TEXTURE_WRAP_REPEAT;
	m_wrap[TEXTURE_COORD_R] = TEXTURE_WRAP_REPEAT;

	m_texgen[TEXTURE_COORD_S] = TEXTURE_GEN_MANUAL;
	m_texgen[TEXTURE_COORD_T] = TEXTURE_GEN_MANUAL;
	m_texgen[TEXTURE_COORD_R] = TEXTURE_GEN_MANUAL;
}

void Texture::load(const char* filename) {

	if (strstr(filename,".tga"))
		loadTGA(filename);
	else
		throw InvalidTextureException(string(filename) + "File Not Found!");
}

void Texture::loadTGA(const char* filename) {

	op_byte TGAheader[12]={0,0,2,0,0,0,0,0,0,0,0,0};
	op_byte TGAcompare[12]; 
	op_byte header[6];  
	op_byte temp;  
	int i;
	
	FILE *file = fopen(filename, "rb");                                     
	
	if (file==NULL ||  
		fread(TGAcompare,1,sizeof(TGAcompare),file) != sizeof(TGAcompare) ||  
		memcmp(TGAheader,TGAcompare,sizeof(TGAheader))!=0 ||            
		fread(header,1,sizeof(header),file)!=sizeof(header)) {
	  
		if (file == NULL)                                           
			throw InvalidTextureException(string(filename));                                         
		else {
		 
			fclose(file);                                          
			throw InvalidTextureException(string(filename));                                         
		}
	}
	
	m_width  = header[1] * 256 + header[0];                         
	m_height = header[3] * 256 + header[2];                        
	
	if (m_width  <=0 || m_height <=0 || (header[4]!=24 && header[4]!=32)) {
		fclose(file);                                                  
		throw InvalidTextureException(string(filename) + "Unknown Depth");                                                 
	}
	
	m_bpp = header[4];                                      
	m_bpp /= 8;                                     
	m_imagesize = m_width*m_height*m_bpp; 
	
	m_data = new op_byte[m_imagesize];                       
	
	if (m_data==NULL || (int)fread(m_data, 1, m_imagesize, file)!=m_imagesize) {
		if (m_data != NULL)                                  
			delete [] m_data;                             

		fclose(file);                                                   
		
		throw InvalidTextureException(string(filename));                                            
	}
	
	for (i=0; i < m_imagesize; i+=m_bpp) {
		temp=m_data[i];                                   
		m_data[i] = m_data[i + 2];            
		m_data[i + 2] = temp;                              
	}
	
	fclose (file);	

}

int Texture::getType() {
	return m_type;
}

op_byte* Texture::getData() {
	return m_data;
}

int Texture::getHeight() {
	return m_height;
}

int Texture::getWidth() {
	return m_width;
}

int Texture::getID() {
	return m_id;
}

int Texture::getBPP() {
	return m_bpp;
}

int Texture::getImageSize() {
	return m_imagesize;
}

string Texture::getName() {
	return m_name;
}

void Texture::setID(int id) {
	m_id = id;
}

int Texture::getFilter() {
	return m_filter;
}

void Texture::setFilter(int filter) {
	m_filter = filter;
}

void Texture::setTexGen(int coord, int type) {
	
	if ((coord & TEXTURE_COORD_S) == TEXTURE_COORD_S)
		m_texgen[TEXTURE_COORD_S]=type;
	if ((coord & TEXTURE_COORD_T) == TEXTURE_COORD_T)
		m_texgen[TEXTURE_COORD_T]=type;
	if ((coord & TEXTURE_COORD_R) == TEXTURE_COORD_R)
		m_texgen[TEXTURE_COORD_R]=type;
}

int Texture::getTexGen(int coord) {
	return m_texgen[coord];
}

void Texture::setWrapMode(int coord, int type) {

	if ((coord & TEXTURE_COORD_S) == TEXTURE_COORD_S)
		m_wrap[TEXTURE_COORD_S]=type;
	if ((coord & TEXTURE_COORD_T) == TEXTURE_COORD_T)
		m_wrap[TEXTURE_COORD_T]=type;
	if ((coord & TEXTURE_COORD_R) == TEXTURE_COORD_R)
		m_wrap[TEXTURE_COORD_R]=type;
}

void Texture::setCombineMode(int combine) {
	m_combine = combine;
}

int Texture::getCombineMode() {
	return m_combine;
}