#ifndef __RENDFACTORY_H__
#define __RENDFACTORY_H__

#include "../optic.h"
#include "defs.h"
#include "renderer.h"

typedef Renderer* (__cdecl* PFNRENDFACTFUN)(HINSTANCE);

class UnknownRendererException : public Exception {
public:

	UnknownRendererException() : Exception("Unknown Renderer Specified") { }
	UnknownRendererException(const string& m) : Exception("Unknown Renderer: " + m) { }

};

class InvalidFactoryConfigException : public Exception {
public:

	InvalidFactoryConfigException() : Exception("Renderer Factory Configuration File Corrupt") { }
	InvalidFactoryConfigException(const string& m) : Exception("Renderer Factory Configuration File Corrupt: " + m) { }

};

class RendererFactory {
public:

	RendererFactory();

	virtual void init(HINSTANCE);
	virtual Renderer* getRenderer(const string&);
	
	virtual void getRenderers(vector<string>&);
	
protected:

	map<string, Renderer*> m_renderers;
};

#endif