#include "rendfactory.h"

RendererFactory::RendererFactory() {

}

void RendererFactory::init(HINSTANCE hInst) {

	ifstream ifile;
	string name,dllname;
	Renderer* rnd;
	HMODULE hDll;
	PFNRENDFACTFUN rnd_init;

	ifile.open(g_configman->getFile("rndfact.cfg").c_str());
	while (!ifile.eof()) {
		ifile >> name; ifile >> dllname;

		if (NULL == (hDll = LoadLibrary(g_configman->getFile(dllname).c_str())))
			throw InvalidFactoryConfigException("Could not find renderer DLL: " + dllname);

		if (NULL == (rnd_init = (PFNRENDFACTFUN) GetProcAddress(hDll,"newRenderer")))
			throw InvalidFactoryConfigException("Corrupt renderer DLL (could not export newRenderer): " + dllname);

		rnd = rnd_init(hInst);

		m_renderers[name] = rnd;
	}

	ifile.close();

}

Renderer* RendererFactory::getRenderer(const string& rend) {

	Renderer* rnd = m_renderers[rend];
	
	if (rnd == NULL)
		throw UnknownRendererException(rend);

	return rnd;
}

void RendererFactory::getRenderers(vector<string>& rends) {

	map<string, Renderer*>::iterator front = m_renderers.begin();
	
	for (; front != m_renderers.end(); front++)
		rends.push_back((*front).first);

}

