#ifndef __RENDERER_H__
#define __RENDERER_H__

#include "../optic.h"
#include "defs.h"
#include "texture.h"
#include "vertex.h"
#include "material.h"
#include "renderproc.h"
#include "primitive.h"
#include "window.h"
#include "transformer.h"
#include "fog.h"
#include "light.h"
#include "font.h"
#include "texturecombiner.h"
#include "vtxshader.h"
#include "pixelshader.h"
#include "vertexarray.h"

class Renderer {
public:

	Renderer() { }

	// Procedural
	virtual void init()=0;
	virtual void clearBuffers()=0;
	virtual Window* getWindow()=0;
//	virtual void getFeatureDescriptor()=0;

	// Rendering
	virtual void render(Primitive*)=0;
	virtual void redirectTexture(Texture*)=0;
	virtual void commitTexture(bool,Texture*)=0;
	virtual void text(int,int, Font*,const char*,...)=0;

	// *** T&L ***
	// State Control
	virtual void setTexCombiner(TextureCombiner*)=0;
	virtual void setFillMode(int)=0;
	virtual void setShadeModel(int)=0;
	virtual void setZBuffer(bool,int)=0;
	virtual void setBlender(bool,int,int)=0;
	virtual void setStencilFunc(bool,int,int,int)=0;
	virtual void setStencilOp(int,int,int)=0;
	
	// Eye Coordinates
	virtual void setCamera(Transformer*)=0;
	virtual Transformer* getCamera()=0;

	// *** Factory Like Stuff *** //
	virtual void* newObject(int)=0;
	virtual void deleteObject(void*)=0;

protected:

	int m_api;
	Window* m_window;
};

#endif