#ifndef __PRIMITIVE_H__
#define __PRIMITIVE_H__

#include "../optic.h"
#include "defs.h"
#include "vertex.h"
#include "material.h"

#include <deque>

#define PRIM_TRIANGLE			0x00010000
#define PRIM_QUAD				0x00020000
#define PRIM_TRIANGLESTRIP		0x00030000
#define PRIM_TRIANGLEFAN		0x00040000
#define PRIM_QUADSTRIP			0x00050000

class Primitive {
public:

	Primitive();

	virtual Vertex& getVertex(int);
	virtual int getNumVertices() const;
	virtual void addVertex(const Vertex&);

	// Quick helpers
	virtual void square(op_float, int tess = 1);
	virtual void rectangle(op_float,op_float, int tess = 1);

	virtual Material* getMaterial();
	virtual void setMaterial(Material*);

	virtual int getType() const;
	virtual void setType(int);

protected:

	int m_type;
	Material* m_material;
	vector<Vertex> m_vertices;

};

#endif