#include "primitive.h"

Primitive::Primitive() {

}

void Primitive::addVertex(const Vertex& vertex) {
	m_vertices.push_back(vertex);
}

int Primitive::getNumVertices() const {
	return m_vertices.size();
}

void Primitive::square(op_float side, int tess) {
	rectangle(side,side);
}

void Primitive::rectangle(op_float width, op_float height, int tess) {

	Vertex verts[5];
	int i;

	m_vertices.clear();

	if (tess == 1)
		m_type = PRIM_QUAD;
	else
		m_type = PRIM_QUADSTRIP;

	// Set up positions
	verts[0].m_position = Vector(0,0,0); verts[1].m_position = Vector(width,0,0);
	verts[2].m_position = Vector(width,height,0); verts[3].m_position = Vector(0,height,0);
	
	// Set up normals
	verts[0].m_normal = verts[1].m_normal = verts[2].m_normal = verts[3].m_normal = Vector(0,0,1);

	// Set up tex coords
	verts[0].m_texcoords.push_back(Vector(0,0,0)); verts[0].m_texcoords.push_back(Vector(0,0,0)); verts[0].m_texcoords.push_back(Vector(0,0,0)); 
	verts[1].m_texcoords.push_back(Vector(1,0,0)); verts[1].m_texcoords.push_back(Vector(1,0,0)); verts[1].m_texcoords.push_back(Vector(1,0,0));
	verts[2].m_texcoords.push_back(Vector(1,1,0)); verts[2].m_texcoords.push_back(Vector(1,1,0)); verts[2].m_texcoords.push_back(Vector(1,1,0));
	verts[3].m_texcoords.push_back(Vector(0,1,0)); verts[3].m_texcoords.push_back(Vector(0,1,0)); verts[3].m_texcoords.push_back(Vector(0,1,0));

	for (i = 0; i < 4; i++) 
		addVertex(verts[i]);

}

Material* Primitive::getMaterial() {
	return m_material;
}

void Primitive::setMaterial(Material* material) {
	m_material = material;
}

void Primitive::setType(int type) {
	m_type = type;
}

int Primitive::getType() const {
	return m_type;
}

Vertex& Primitive::getVertex(int index) {

	if (index >= m_vertices.size())
		return Vertex();

	return m_vertices.at(index);
}
