/** @Description Material interface
*	@Author Mike Maxim
*/

#ifndef __MATERIAL_H__
#define __MATERIAL_H__

#include "../optic.h"
#include "texture.h"
#include "defs.h"

class Material {
public:

	Material();

	virtual void bindAll(bool bindarray = false)=0;
	virtual void bindBase()=0;
	virtual void bindTextures(bool bindarray = false)=0;

	virtual void unbindTextures(bool bindarray = false)=0;
	virtual void unbindTexture(int)=0;

	Texture* getTexture(int);
	int getNumTextures();
	Triple getDiffuse();
	Triple getSpecular();
	op_float getShininess();
	op_float getOpacity();
	op_float getReflectivity();

	void addTexture(Texture*);
	void insertTexture(int,Texture*);
	void removeTextures();
	void removeTexture(int);
	void setDiffuse(const Triple&);
	void setSpecular(const Triple&);
	void setShininess(op_float);
	void setOpacity(op_float);
	void setReflectivity(op_float);

protected:

	vector<Texture*> m_textures;
	Triple m_diffuse,m_specular;
	op_float m_opacity,m_reflectivity,m_shininess;
};

#endif