#include "material.h"

Material::Material() : m_shininess(3.0) { 

	m_diffuse = Vector(1,1,1);
	m_specular = Vector(1,1,1);
	m_opacity = 1.0;
	m_reflectivity = 1.0;
	
}

Triple Material::getDiffuse() {
	return m_diffuse;
}

Triple Material::getSpecular() {
	return m_specular;
}

op_float Material::getShininess() {
	return m_shininess;
}

Texture* Material::getTexture(int index) {
	
	if (index >= m_textures.size())
		return NULL;

	return m_textures[index];
}

int Material::getNumTextures() {
	return m_textures.size();
}

op_float Material::getOpacity() {
	return m_opacity;
}

op_float Material::getReflectivity() {
	return m_reflectivity;
}

void Material::setDiffuse(const Triple& diffuse) {
	m_diffuse = diffuse;
}

void Material::setSpecular(const Triple& specular) {
	m_specular = specular;
}

void Material::setShininess(op_float shininess) {
	m_shininess = shininess;
}

void Material::addTexture(Texture* texture) {
	m_textures.push_back(texture);
}

void Material::insertTexture(int index, Texture* texture) {
	
	if (index >= m_textures.size())
		m_textures.resize(index+1,NULL);

	m_textures[index] = texture;
}

void Material::removeTextures() {
	m_textures.clear();
}

void Material::removeTexture(int index) {
	
	int i;
	vector<Texture*> tmp;
	for (i = 0; i < m_textures.size(); i++) 
		tmp.push_back(m_textures[i]);		
	
	m_textures.clear();

	for (i = 0; i < tmp.size(); i++) {
		if (i == index)
			m_textures.push_back(NULL);
		else
			m_textures.push_back(tmp[i]);
	}
}

void Material::setReflectivity(op_float reflectivity) {
	m_reflectivity = reflectivity;
}

void Material::setOpacity(op_float opacity) {
	m_opacity = opacity;
}

