/** @Description Built-In Renderer Lights (Per-Vertex) (Effects engine has more advanced "light" models (PPL))
  * @Author Mike Maxim
  */

#ifndef __LIGHT_H__
#define __LIGHT_H__

#include "../optic.h"
#include "defs.h"

/** Built-In Light types */
#define LIGHT_TYPE_POINT				0x10
#define LIGHT_TYPE_DIRECTIONAL			0x11
#define LIGHT_TYPE_SPOT					0x12

/** Lighting Model */
#define LIGHT_MODEL_INFINITEVIEWER		0x20
#define LIGHT_MODEL_LOCALVIEWER			0x21

/** Attenutation */
#define LIGHT_ATTENUATION_CONSTANT		0x30
#define LIGHT_ATTENUATION_LINEAR		0x31
#define LIGHT_ATTENUATION_QUADRATIC		0x32

class Light {
public:

	Light();

	virtual void enable()=0;
	virtual void disable()=0;

	// Ordinary Props
	virtual int getType();
	virtual int getModel();
	virtual Vector& getPosition();
	virtual Triple& getAmbient();
	virtual Triple& getDiffuse();
	virtual Triple& getSpecular(); 
	virtual void setAttenuation(int,op_float);

	// Spotlight Stuff
	virtual void setSpotDirection(const Vector&);
	virtual void setSpotExponent(op_float);
	virtual void setSpotCutoff(op_float);

	virtual void setType(int);
	virtual void setModel(int);

protected:

	int m_type,m_model;
	Vector m_position,m_spotdir;
	Triple m_ambient,m_diffuse,m_specular;
	op_float m_atten[3],m_spotexp,m_spotcuf;


};

#endif