#include "light.h"

Light::Light() { 
	m_atten[LIGHT_ATTENUATION_CONSTANT]=1.0;
	m_atten[LIGHT_ATTENUATION_LINEAR]=0.0;
	m_atten[LIGHT_ATTENUATION_QUADRATIC]=0.0;

	m_diffuse[0] = m_diffuse[1] = m_diffuse[2] = 1.0f;
	m_ambient[0] = m_ambient[1] = m_ambient[2] = 0.2f;
	m_specular[0] = m_specular[1] = m_specular[2] = 1.0f;

	m_position[2] = -5.0;

	m_model = LIGHT_MODEL_LOCALVIEWER;
	m_type = LIGHT_TYPE_POINT;
}

Triple& Light::getAmbient() {
	return m_ambient;
}

Triple& Light::getDiffuse() {
	return m_diffuse;
}

Triple& Light::getSpecular() {
	return m_specular;
}

Vector& Light::getPosition() {
	return m_position;
}

int Light::getType() {
	return m_type;
}

void Light::setType(int type) {
	m_type = type;
}

void Light::setAttenuation(int index, op_float val) {
	m_atten[index]=val;
}

void Light::setSpotCutoff(op_float cutoff) {
	m_spotcuf = cutoff;
}

void Light::setSpotDirection(const Vector& dir) {
	m_spotdir = dir;
}

void Light::setSpotExponent(op_float exp) {
	m_spotexp = exp;
}

void Light::setModel(int model) {
	m_model = model;
}

int Light::getModel() {
	return m_model;
}