#ifndef __GLWINDOW_H__
#define __GLWINDOW_H__

#include "defs.h"
#include "glfrustum.h"
#include "glviewer.h"

#define IDI_OPTIC	102

class GLWindow : public Window {
public:

	GLWindow(HINSTANCE);

	virtual void create(const char*,op_rect,int,bool);
	virtual void destroy();
	virtual void show();
	virtual void hide();
	virtual void caption(const char*);

	virtual void resize(int,int);
	virtual void fullscreen(bool);
	virtual bool isFullscreen();

	virtual HDC getDeviceContext();

	virtual void showframebuffer();

	static vector<GLWindow*> m_windows;
	friend LRESULT CALLBACK GLWndProc(HWND,UINT,WPARAM,LPARAM);
	friend GLWindow* locate_window(HWND);

private:

	void setup_framebuffer(int);

	HINSTANCE m_hInstance;
	HDC m_hDC;
	HGLRC m_hRC;
	op_rect m_viewport;

	bool m_fullscreen;

};

#endif