#include "stdafx.h"
#include "glvtxshader.h"

GLVertexShader::GLVertexShader() : m_id(0) {


}


void GLVertexShader::enable() {

	glEnable(GL_VERTEX_PROGRAM_NV);
	glBindProgramNV(GL_VERTEX_PROGRAM_NV,m_id);

}

void GLVertexShader::disable() {

	glDisable(GL_VERTEX_PROGRAM_NV);
}

void GLVertexShader::execute(op_float* params) {

	glExecuteProgramNV(GL_VERTEX_STATE_PROGRAM_NV, m_id, params);
}

void GLVertexShader::load(const char* name) {

	if (strstr(name,".vsd"))
		loadASMShaderFile(name);
	else if (strstr(name,".cg"))
		loadCGShaderFile(name);
	else
		throw InvalidShaderException("Unknown Shader Type");
}

void GLVertexShader::setConstant(int reg, const Vector& v) {

	glProgramParameter4fNV(GL_VERTEX_PROGRAM_NV,reg,v[0],v[1],v[2], v[3]);
}

void GLVertexShader::trackMatrix(int reg, int matrix, int trans) {

	glTrackMatrixNV(GL_VERTEX_PROGRAM_NV, reg, map_to_gl(matrix), map_to_gl(trans));

}

void GLVertexShader::loadASMShaderFile(const char* name) {

	char* codebuffer;
	int bytes;
	FILE* file;

	if (NULL == (file = fopen(name,"rb")))
		throw InvalidShaderException("File Not Found");

	fseek(file,0,SEEK_END);
	bytes = ftell(file);
	rewind(file);

	codebuffer = new char[bytes+1];
	fread(codebuffer,1,bytes,file);
	codebuffer[bytes]='\0';

	glGenProgramsNV(1, &m_id);
	glBindProgramNV(GL_VERTEX_PROGRAM_NV, m_id);

	nvparse(codebuffer);

	fclose(file);
}

void GLVertexShader::loadCGShaderFile(const char* name) {

}