#include "stdafx.h"
#include "glvertexarray.h"

GLVertexArray::GLVertexArray() {

}

void GLVertexArray::execute(int type) {

	int i;

	for (i = 0; i < 20; i++) {
		if (m_texcoords[i] != NULL) {
			glClientActiveTextureARB(GL_TEXTURE0_ARB+i);			
			glEnableClientState(GL_TEXTURE_COORD_ARRAY);
			glTexCoordPointer(2,GL_FLOAT,0,m_texcoords[i]);
		}
		else {
			glClientActiveTextureARB(GL_TEXTURE0_ARB+i);
			glDisableClientState(GL_TEXTURE_COORD_ARRAY);
		}
	}
		
	if (m_normals != NULL) {
		glEnableClientState(GL_NORMAL_ARRAY);
		glNormalPointer(GL_FLOAT,0,m_normals);
	}
	else
		glDisableClientState(GL_NORMAL_ARRAY);

	if (m_vertices != NULL) {
		glEnableClientState(GL_VERTEX_ARRAY);
		glVertexPointer(3,GL_FLOAT,0,m_vertices);
	}
	
	switch (type) {
	case VTXARRAY_TYPE_TRIANGLES:
		glDrawElements(GL_TRIANGLES,m_numindices,GL_UNSIGNED_INT,m_indices); 
		break;
	case VTXARRAY_TYPE_QUADS:
		glDrawElements(GL_QUADS,m_numindices,GL_UNSIGNED_INT,m_indices);
		break;
	};
}