#ifndef __GLTRANSFORMER_H__
#define __GLTRANSFORMER_H__

#include "defs.h"

class GLTransformer : public Transformer {
public:

	GLTransformer();

	// Transformations
	virtual void rotate(int,op_float);
	virtual void rotate_axisangle(op_float,const Vector&);
	virtual void translate(const Vector&);
	virtual void scale(const Vector&);
	virtual void mult(const Matrix&);
	virtual void lookat(const Vector&, const Vector&, const Vector&);
	virtual void identity();

	// State
	virtual void bind(int);
	virtual void getCurrentMatrix(Matrix&);

	virtual void push();
	virtual void pop();

	virtual void persist();
	virtual void restore();

protected:

	int m_matrix;
	op_float m_saved[16];
};

#endif