#include "stdafx.h"
#include "gltransformer.h"

GLTransformer::GLTransformer() : m_matrix(TRANS_MATRIX_WORLD) {

}

void GLTransformer::bind(int matrix) {

	m_matrix = matrix;

	glMatrixMode(map_to_gl(m_matrix));
}

void GLTransformer::identity() {
	glLoadIdentity();
}

void GLTransformer::lookat(const Vector& eye, const Vector& at, const Vector& up) {
	gluLookAt(eye[0],eye[1],eye[2],at[0],at[1],at[2],up[0],up[1],up[2]);
}

void GLTransformer::push() {
	glPushMatrix();
}

void GLTransformer::pop() {
	glPopMatrix();
}

void GLTransformer::translate(const Vector& trans) {
	glTranslatef(trans[0],trans[1],trans[2]);
}

void GLTransformer::rotate(int axis, op_float rotate) {

	switch (axis) {
	case TRANS_AXIS_X:
		glRotatef(rotate,1.0f,0.0f,0.0f);
		break;
	case TRANS_AXIS_Y:
		glRotatef(rotate,0.0f,1.0f,0.0f);
		break;
	case TRANS_AXIS_Z:
		glRotatef(rotate,0.0f,0.0f,1.0f);
		break;
	};

}

void GLTransformer::rotate_axisangle(op_float angle, const Vector& axis) {
	glRotatef(angle,axis[0],axis[1],axis[2]);
}

void GLTransformer::scale(const Vector& scale) {
	glScalef(scale[0],scale[1],scale[2]);
}

void GLTransformer::getCurrentMatrix(Matrix& matrix) {

	op_float rmatrix[16];

	switch (m_matrix) {
	case TRANS_MATRIX_WORLD:
		glGetFloatv(GL_MODELVIEW_MATRIX,rmatrix);
		break;
	case TRANS_MATRIX_PROJECTION:
		glGetFloatv(GL_PROJECTION_MATRIX,rmatrix);
		break;
	case TRANS_MATRIX_TEXTURE:
		glGetFloatv(GL_TEXTURE_MATRIX,rmatrix);
		break;
	};

	matrix.fromGLmatrix(rmatrix);
}

void GLTransformer::mult(const Matrix& matrix) {

	op_float rmatrix[16];

	matrix.toGLmatrix(rmatrix);
	glMultMatrixf(rmatrix);

}

void GLTransformer::persist() {
	glGetFloatv(map_to_gl(m_matrix), m_saved);
}

void GLTransformer::restore() {

	identity();
	glMultMatrixf(m_saved);

}