#ifndef __GLTEXTURECOMBINER_H__
#define __GLTEXTURECOMBINER_H__

#include "defs.h"
#include "glh_extensions.h"

class GLTexUnitControl {
public:

	GLTexUnitControl();
	GLTexUnitControl(const GLTexUnitControl&);

	GLTexUnitControl& operator =(const GLTexUnitControl&);

	int m_operation;
	int m_sources[3];
	int m_operands[3];

private:

	void copy(const GLTexUnitControl&);
};

class GLTextureCombiner : public TextureCombiner {
public:

	GLTextureCombiner();

	virtual void loadScript(const char*);

	virtual void enable();
	virtual void disable();
	
private:

	// Version independent
	int parse_version(char*);
	
	// Version 1,0
	void parse_v10(ifstream&);
	GLTexUnitControl parse_v10_normal(const vector<string>&);
	map<string, pair<int,int> > m_v10_map;

	void tokenize(char*,vector<string>&);
	void reset();

	vector<GLTexUnitControl> m_units;
};

#endif
