#include "stdafx.h"
#include "gltexturecombiner.h"

GLTexUnitControl::GLTexUnitControl() : m_operation(GL_MODULATE) {
	
	m_sources[0] = m_sources[1] = m_sources[2] = -1;
	m_operands[0] = m_operands[1] = m_operands[2] = -1;
}

GLTexUnitControl::GLTexUnitControl(const GLTexUnitControl& tex) {
	copy(tex);
}

GLTexUnitControl& GLTexUnitControl::operator =(const GLTexUnitControl& tex) {

	if (this != &tex)
		copy(tex);

	return *this;
}

void GLTexUnitControl::copy(const GLTexUnitControl& tex) {

	int i;

	for (i = 0; i < 3; i++) {
		m_sources[i] = tex.m_sources[i];
		m_operands[i] = tex.m_operands[i];
	}

	m_operation = tex.m_operation;
}

GLTextureCombiner::GLTextureCombiner() {
	
	pair<int,int> gl_com;

	gl_com.first = GL_PRIMARY_COLOR_EXT; gl_com.second = GL_SRC_COLOR;
	m_v10_map["pc"] = gl_com;
	gl_com.first = GL_PRIMARY_COLOR_EXT; gl_com.second = GL_ONE_MINUS_SRC_COLOR;
	m_v10_map["ipc"] = gl_com;
	gl_com.first = GL_TEXTURE; gl_com.second = GL_SRC_COLOR;
	m_v10_map["tex"] = gl_com;
	gl_com.first = GL_TEXTURE; gl_com.second = GL_ONE_MINUS_SRC_COLOR;
	m_v10_map["itex"] = gl_com;
	gl_com.first = GL_PREVIOUS_EXT; gl_com.second = GL_SRC_COLOR;
	m_v10_map["prev"] = gl_com;
	gl_com.first = GL_PREVIOUS_EXT; gl_com.second = GL_ONE_MINUS_SRC_COLOR;
	m_v10_map["iprev"] = gl_com;
	gl_com.first = GL_DOT3_RGB_EXT; gl_com.second = 0;
	m_v10_map["dot"] = gl_com;
	gl_com.first = GL_MODULATE; gl_com.second = 0;
	m_v10_map["*"] = gl_com;
	gl_com.first = GL_ADD; gl_com.second = 0;
	m_v10_map["+"] = gl_com;
	gl_com.first = GL_INTERPOLATE_EXT; gl_com.second = 0;
	m_v10_map["lerp"] = gl_com;

}

void GLTextureCombiner::enable() {
	
	int gltexunit = GL_TEXTURE0_ARB;
	int i;

	for (i = 0; i < m_units.size(); i++) {

		glActiveTextureARB(gltexunit);
		glTexEnvi(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_COMBINE_EXT);
		glTexEnvi(GL_TEXTURE_ENV,GL_COMBINE_RGB_EXT,m_units[i].m_operation);
		glTexEnvi(GL_TEXTURE_ENV,GL_SOURCE0_RGB_EXT,m_units[i].m_sources[0]);
		glTexEnvi(GL_TEXTURE_ENV,GL_OPERAND0_RGB_EXT,m_units[i].m_operands[0]);
		glTexEnvi(GL_TEXTURE_ENV,GL_SOURCE1_RGB_EXT,m_units[i].m_sources[1]);
		glTexEnvi(GL_TEXTURE_ENV,GL_OPERAND1_RGB_EXT,m_units[i].m_operands[1]);

		if (m_units[i].m_sources[2] != -1) {
			glTexEnvi(GL_TEXTURE_ENV,GL_SOURCE2_RGB_EXT,m_units[i].m_sources[2]);
			glTexEnvi(GL_TEXTURE_ENV,GL_OPERAND2_RGB_EXT,m_units[i].m_operands[2]);
		}

		gltexunit++;
	}

}

void GLTextureCombiner::disable() {

	
}

void GLTextureCombiner::loadScript(const char* filename) {

	ifstream ifile;
	char buffer[512];
	int version;

	reset();

	ifile.open(filename);

	ifile.getline(buffer,512);
	version = parse_version(buffer);
	switch (version) {
	case TEXTURE_COMBINER_VERSION_1_0:
		parse_v10(ifile);
		break;
	};

	ifile.close();
}

void GLTextureCombiner::parse_v10(ifstream& ifile) {

	char buffer[256];
	vector<string> tokens;

	ifile.getline(buffer,256);
	if (string(buffer) != ".code")
		throw InvalidCombinerScriptException("Missing code segment");

	while (!ifile.eof()) {

		ifile.getline(buffer,256);
		tokenize(buffer,tokens);

		if (tokens.size() == 3 || tokens.size() == 4)
			m_units.push_back(parse_v10_normal(tokens));
		else
			throw InvalidCombinerScriptException("Syntax Error: Too many or too less tokens on unit line");	
	}
}

GLTexUnitControl GLTextureCombiner::parse_v10_normal(const vector<string>& tokens) {
	
	GLTexUnitControl unit;
	int i,index=0;

	unit.m_operation = m_v10_map[tokens[1]].first;

	for (i = 0; i < tokens.size(); i++) {

		if (i == 1) continue;

		unit.m_sources[index] = m_v10_map[tokens[i]].first;
		unit.m_operands[index] = m_v10_map[tokens[i]].second;
		index++;
	}	

	return unit;
}

int GLTextureCombiner::parse_version(char* version) {

	int i;
	vector<string> tokens;

	tokenize(version,tokens);

	if (tokens.size() != 2 || tokens[0] != "Optic")
		throw InvalidCombinerScriptException("Missing version line");

	for (i = 0; i < m_knownversions.size(); i++) 
		if (m_knownversions[i] == tokens[1])
			return i;

	throw InvalidCombinerScriptException("Invalid script version");
}

void GLTextureCombiner::tokenize(char* line, vector<string>& tokens) {

	char* tPtr;
	char tline[512],seps[] = " ";
	
	tokens.clear();

	strcpy(tline,line);
	tPtr = strtok(tline,seps);
	while (tPtr != NULL) {
		tokens.push_back(string(tPtr));
		tPtr = strtok(NULL,seps);
	}

}

void GLTextureCombiner::reset() {

	m_units.clear();
}